/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.AbstractLexer;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.Context;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.JShellParser;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.StrReader;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.Token;

public class DefaultLexer
extends AbstractLexer {
    private final JShellParser jShellParser;
    public Stack<Context> ctx = new Stack();
    private LinkedList<Token> tokensBuffer = new LinkedList();

    public DefaultLexer(JShellParser jShellParser) {
        this.jShellParser = jShellParser;
    }

    public Token continueReadDollarWord() {
        StrReader reader = this.jShellParser.strReader();
        int char0 = reader.peekChar();
        if (char0 == 36) {
            int n;
            StringBuilder sb = new StringBuilder();
            reader.read();
            while ((n = reader.read()) >= 0) {
                char nc = (char)n;
                boolean doBreak = false;
                switch (n) {
                    case 45: 
                    case 47: 
                    case 92: {
                        reader.pushBackChar(nc);
                        doBreak = true;
                        break;
                    }
                    default: {
                        if (reader.isWordChar(n)) {
                            sb.append((char)n);
                            break;
                        }
                        reader.pushBackChar(nc);
                        doBreak = true;
                    }
                }
                if (!doBreak) continue;
                break;
            }
            return new Token("$WORD", sb.toString(), "$" + sb);
        }
        throw new IllegalArgumentException("unsupported");
    }

    public Token continueReadWord() {
        int char0;
        StrReader reader = this.jShellParser.strReader();
        if (reader.isWordChar(char0 = reader.peekChar())) {
            int n;
            StringBuilder sb = new StringBuilder();
            reader.read();
            sb.append((char)char0);
            while ((n = reader.read()) >= 0) {
                char nc = (char)n;
                boolean doBreak = false;
                switch (n) {
                    case 92: {
                        n = reader.read();
                        if (n >= 0) {
                            sb.append((char)n);
                            break;
                        }
                        doBreak = true;
                        break;
                    }
                    default: {
                        if (reader.isWordChar(n)) {
                            sb.append((char)n);
                            break;
                        }
                        reader.pushBackChar(nc);
                        doBreak = true;
                    }
                }
                if (!doBreak) continue;
                break;
            }
            return new Token("WORD", sb.toString(), sb.toString());
        }
        throw new IllegalArgumentException("unsupported");
    }

    public Token continueReadWhite() {
        StrReader reader = this.jShellParser.strReader();
        int r = reader.peekChar();
        if (r == 10) {
            StringBuilder sb = new StringBuilder();
            reader.read();
            sb.append((char)r);
            return new Token("NEWLINE", sb.toString(), sb.toString());
        }
        if (r == 13) {
            StringBuilder sb = new StringBuilder();
            sb.append((char)reader.read());
            r = reader.peekChar();
            if (r == 10) {
                sb.append((char)reader.read());
            }
            return new Token("NEWLINE", sb.toString(), sb.toString());
        }
        if (r <= 32) {
            int r2;
            StringBuilder sb = new StringBuilder();
            reader.read();
            sb.append((char)r);
            while ((r2 = reader.read()) >= 0) {
                if (r2 <= 32 && r2 != 10 && r2 != 13) {
                    sb.append((char)r2);
                    continue;
                }
                reader.pushBackChar((char)r2);
                break;
            }
            return new Token("WHITE", sb.toString(), sb.toString());
        }
        throw new IllegalArgumentException("Unsupported");
    }

    public Token processContext(String prefix, Context t) {
        Token tt;
        StrReader reader = this.jShellParser.strReader();
        ArrayList<Token> all = new ArrayList<Token>();
        Context c = this.ctx.peek();
        int before = this.ctx.size();
        this.ctx.push(t);
        StringBuilder sb = new StringBuilder();
        while (this.jShellParser.lexer().ctx.peek() != c && (tt = this.jShellParser.lexer().nextToken(before)) != null) {
            all.add(tt);
            sb.append(tt.getImage());
        }
        return new Token(prefix, all, sb.toString());
    }

    public void popContext() {
        this.ctx.pop();
    }

    public Iterable<Token> tokens() {
        return new Iterable<Token>(){

            @Override
            public Iterator<Token> iterator() {
                return new Iterator<Token>(){
                    Token t;

                    @Override
                    public boolean hasNext() {
                        this.t = DefaultLexer.this.nextToken();
                        return this.t != null;
                    }

                    @Override
                    public Token next() {
                        return this.t;
                    }
                };
            }
        };
    }

    public void pushBackToken(Token t) {
        if (t != null) {
            this.tokensBuffer.addFirst(t);
        }
    }

    public boolean skipWhitesNewLinesAndComments() {
        boolean some = false;
        Token t;
        while ((t = this.peekToken()) != null) {
            if (!(t.type.equals("WHITE") || t.type.equals("NEWLINE") || t.type.equals("#"))) {
                return some;
            }
            some = true;
            this.nextToken();
        }
        return some;
    }

    public Token nextNonWhiteToken() {
        Token t;
        do {
            if ((t = this.nextToken()) != null) continue;
            return null;
        } while (t.type.equals("WHITE"));
        return t;
    }

    public Token peedTokenSafe() {
        Token t = this.peekToken();
        if (t == null) {
            return new Token("", "", "");
        }
        return t;
    }

    @Override
    public Token peekToken() {
        if (!this.tokensBuffer.isEmpty()) {
            return this.tokensBuffer.getFirst();
        }
        while (!this.ctx.isEmpty()) {
            Token u = this.ctx.peek().nextToken();
            if (u != null) {
                this.tokensBuffer.add(u);
                return u;
            }
            this.ctx.pop();
        }
        return null;
    }

    @Override
    public Token nextToken() {
        if (!this.tokensBuffer.isEmpty()) {
            return this.tokensBuffer.removeFirst();
        }
        while (!this.ctx.isEmpty()) {
            Token u = this.ctx.peek().nextToken();
            if (u != null) {
                return u;
            }
            this.ctx.pop();
        }
        return null;
    }

    public Token nextToken(int before) {
        do {
            if (this.ctx.isEmpty()) {
                return null;
            }
            Token u = this.ctx.peek().nextToken();
            if (u != null) {
                return u;
            }
            this.ctx.pop();
        } while (this.ctx.size() > before);
        return null;
    }
}

