/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellAutoCompleteCandidate;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;

class NshAutoCompleter
implements NutsCommandAutoCompleteResolver {
    NshAutoCompleter() {
    }

    public List<NutsArgumentCandidate> resolveCandidates(NutsCommandLine commandline, int wordIndex, NutsSession session) {
        ArrayList<NutsArgumentCandidate> candidates = new ArrayList<NutsArgumentCandidate>();
        JShellContext fileContext = (JShellContext)session.env().getProperties().get(JShellContext.class.getName());
        if (wordIndex == 0) {
            for (JShellBuiltin command : fileContext.builtins().getAll()) {
                candidates.add(new NutsArgumentCandidate(command.getName()));
            }
        } else {
            ArrayList<String> autoCompleteWords = new ArrayList<String>(Arrays.asList(commandline.toStringArray()));
            int x = commandline.getCommandName().length();
            List<JShellAutoCompleteCandidate> autoCompleteCandidates = fileContext.resolveAutoCompleteCandidates(commandline.getCommandName(), autoCompleteWords, wordIndex, commandline.toString());
            for (JShellAutoCompleteCandidate cmdCandidate0 : autoCompleteCandidates) {
                String value;
                JShellAutoCompleteCandidate cmdCandidate = cmdCandidate0;
                if (cmdCandidate == null || NutsBlankable.isBlank((String)(value = cmdCandidate.getValue()))) continue;
                String display = cmdCandidate.getDisplay();
                if (NutsBlankable.isBlank((String)display)) {
                    display = value;
                }
                candidates.add(new NutsArgumentCandidate(value, display));
            }
        }
        return candidates;
    }
}

