/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.util.HashMap;
import java.util.Map;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nsh.NutsBuiltinManager;
import net.thevpc.nuts.toolbox.nsh.jshell.AbstractJShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellAliasManager;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellCommandManager;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellFileSystem;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellFunctionManager;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellAliasManager;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltinManager;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellFileSystem;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellFunctionManager;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellResult;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVariables;

public class DefaultJShellContext
extends AbstractJShellContext {
    private static final JShellResult OK_RESULT = new JShellResult(0, null, null);
    public String oldCommandLine = null;
    public JShellResult lastResult = OK_RESULT;
    public JShellContext parentContext;
    public int commandLineIndex = -1;
    private JShell shell;
    private JShellVariables vars;
    private JShellNode rootNode;
    private JShellNode parentNode;
    private Map<String, Object> userProperties = new HashMap<String, Object>();
    private JShellFunctionManager functionManager = new DefaultJShellFunctionManager();
    private JShellAliasManager aliasManager = new DefaultJShellAliasManager();
    private JShellBuiltinManager builtinManager;
    private String cwd = System.getProperty("user.dir");
    private JShellFileSystem fileSystem;
    private NutsCommandAutoComplete autoComplete;

    public DefaultJShellContext(JShell shell, JShellNode rootNode, JShellNode parentNode, JShellContext parentContext, NutsWorkspace workspace, NutsSession session, JShellVariables vars, String serviceName, String[] args) {
        this(parentContext);
        Object object = workspace != null ? workspace : (workspace = parentContext != null ? parentContext.getWorkspace() : null);
        if (session == null && workspace != null) {
            session = this.getWorkspace().createSession();
        }
        this.setSession(session);
        this.setServiceName(serviceName);
        this.setArgs(args);
        this.vars = new JShellVariables(this);
        this.shell = shell;
        this.setFileSystem(new DefaultJShellFileSystem());
        if (parentContext != null) {
            this.setCwd(parentContext.getCwd());
        }
        this.setRootNode(rootNode);
        this.setParentNode(parentNode);
        if (parentContext != null) {
            this.vars().set(parentContext.vars());
            this.setBuiltins(parentContext.builtins());
            for (String string : parentContext.aliases().getAll()) {
                this.aliases().set(string, parentContext.aliases().get(string));
            }
        } else {
            for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
                this.vars().export(entry.getKey(), entry.getValue());
            }
            this.setBuiltins(new NutsBuiltinManager());
            JShellAliasManager a = this.aliases();
            a.set(".", "source");
            a.set("[", "test");
            a.set("ll", "ls");
            a.set("..", "cd ..");
            a.set("...", "cd ../..");
        }
        if (vars != null) {
            for (Map.Entry entry : vars.getAll().entrySet()) {
                this.vars().set((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.parentContext = parentContext;
        if (parentContext != null) {
            this.setCwd(parentContext.getCwd());
        }
    }

    public DefaultJShellContext(JShellContext other) {
        this.parentContext = other;
        this.copyFrom(other);
    }

    @Override
    public JShell getShell() {
        return this.shell;
    }

    @Override
    public JShellNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public JShellContext setRootNode(JShellNode root) {
        this.rootNode = root;
        return this;
    }

    @Override
    public JShellNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public JShellContext setParentNode(JShellNode parent) {
        this.parentNode = parent;
        return this;
    }

    @Override
    public JShellVariables vars() {
        return this.vars;
    }

    @Override
    public JShellFunctionManager functions() {
        return this.functionManager;
    }

    @Override
    public JShellContext setEnv(Map<String, String> env) {
        if (env != null) {
            this.vars.set(env);
        }
        return this;
    }

    @Override
    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }

    @Override
    public String getCwd() {
        return this.cwd;
    }

    @Override
    public String getHome() {
        return System.getProperty("user.home");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCwd(String cwd) {
        JShellFileSystem fs = this.getFileSystem();
        if (cwd == null || cwd.isEmpty()) {
            this.cwd = fs.getHomeWorkingDir(this.getSession());
            return;
        } else {
            String r;
            String string = r = fs.isAbsolute(cwd, this.getSession()) ? cwd : fs.getAbsolutePath(this.cwd + "/" + cwd, this.getSession());
            if (!fs.exists(r, this.getSession())) throw new IllegalArgumentException("no such file or directory : " + cwd);
            if (!fs.isDirectory(r, this.getSession())) throw new IllegalArgumentException("not a directory : " + cwd);
            this.cwd = r;
        }
    }

    @Override
    public JShellFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public void setFileSystem(JShellFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.setCwd(this.fileSystem.getInitialWorkingDir(this.getSession()));
    }

    @Override
    public JShellContext getParentContext() {
        return this.parentContext;
    }

    @Override
    public JShellAliasManager aliases() {
        return this.aliasManager;
    }

    @Override
    public void setBuiltins(JShellBuiltinManager builtinsManager) {
        this.builtinManager = builtinsManager;
    }

    @Override
    public JShellBuiltinManager builtins() {
        if (this.builtinManager == null) {
            this.builtinManager = new DefaultJShellCommandManager();
        }
        return this.builtinManager;
    }

    @Override
    public JShellResult getLastResult() {
        return this.lastResult;
    }

    @Override
    public void setLastResult(JShellResult lastResult) {
        this.lastResult = lastResult == null ? OK_RESULT : lastResult;
    }

    @Override
    public void setAliases(JShellAliasManager aliasManager) {
        this.aliasManager = aliasManager == null ? new DefaultJShellAliasManager() : aliasManager;
    }

    @Override
    public void copyFrom(JShellContext other) {
        if (other != null) {
            super.copyFrom(other);
            this.shell = other.getShell();
            this.vars = other.vars();
            this.userProperties = new HashMap<String, Object>();
            this.userProperties.putAll(other.getUserProperties());
            this.parentContext = other.getParentContext();
        }
    }

    @Override
    public NutsCommandAutoComplete getAutoComplete() {
        return this.autoComplete;
    }

    @Override
    public void setAutoComplete(NutsCommandAutoComplete autoComplete) {
        this.autoComplete = autoComplete;
    }

    @Override
    public void setFunctionManager(JShellFunctionManager functionManager) {
        this.functionManager = functionManager == null ? new DefaultJShellFunctionManager() : functionManager;
    }
}

