/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellHistory;

public abstract class AbstractJShellHistory
implements JShellHistory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(NutsPath reader) throws IOException {
        try (BufferedReader bufferedReader = null;){
            bufferedReader = new BufferedReader(new InputStreamReader(reader.getInputStream()));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                this.add(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = null;){
            bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                this.add(line);
            }
        }
    }

    @Override
    public void save(NutsPath file) throws IOException {
        if (file == null) {
            return;
        }
        if (file.getParent() != null) {
            file.getParent().mkdirs();
        }
        try (PrintWriter w = null;){
            w = new PrintWriter(new OutputStreamWriter(file.getOutputStream()));
            this.save(w);
        }
    }

    @Override
    public void save(PrintWriter writer) throws IOException {
        for (String element : this.getElements()) {
            writer.println(element);
        }
    }

    @Override
    public void save(PrintStream writer) throws IOException {
        for (String element : this.getElements()) {
            writer.println(element);
        }
    }

    @Override
    public void append(JShellHistory other) {
        for (String element : other.getElements(-1)) {
            this.add(element);
        }
    }
}

