/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCompress;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

public class ZipCommand
extends SimpleJShellBuiltin {
    public ZipCommand() {
        super("zip", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (commandLine.next(new String[]{"-r"}) != null) {
            options.r = true;
            return true;
        }
        if (commandLine.peek().isOption()) {
            return false;
        }
        if (commandLine.peek().isNonOption()) {
            String path = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
            NutsPath file = NutsPath.of((String)path, (NutsSession)session).toAbsolute(context.getShellContext().getCwd());
            if (options.outZip == null) {
                options.outZip = file;
            } else {
                options.files.add(file);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (options.files.isEmpty()) {
            commandLine.required(NutsMessage.cstyle((String)"missing input-files", (Object[])new Object[0]));
        }
        if (options.outZip == null) {
            commandLine.required(NutsMessage.cstyle((String)"missing out-zip", (Object[])new Object[0]));
        }
        NutsCompress aa = NutsCompress.of((NutsSession)session).setTarget(options.outZip);
        for (NutsPath file : options.files) {
            aa.addSource(file);
        }
        aa.run();
    }

    private static class Options {
        List<NutsPath> files = new ArrayList<NutsPath>();
        NutsPath outZip = null;
        boolean r = false;

        private Options() {
        }
    }
}

