/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsRepository;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUser;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class WhoamiCommand
extends SimpleJShellBuiltin {
    public WhoamiCommand() {
        super("whoami", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options config = (Options)context.getOptions();
        switch (commandLine.peek().getKey().getString()) {
            case "--all": 
            case "-a": {
                config.argAll = true;
                config.nutsUser = true;
                commandLine.skip();
                return true;
            }
            case "--nuts": 
            case "-n": {
                config.nutsUser = true;
                commandLine.skip();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Result result = new Result();
        Options options = (Options)context.getOptions();
        if (!options.nutsUser) {
            result.login = System.getProperty("user.name");
        } else {
            NutsSession session = context.getSession();
            String login = session.security().getCurrentUsername();
            result.login = login;
            if (options.argAll) {
                NutsUser user = session.security().findUser(login);
                TreeSet<String> groups = new TreeSet<String>(Arrays.asList(user.getGroups()));
                TreeSet<String> rights = new TreeSet<String>(Arrays.asList(user.getPermissions()));
                TreeSet<String> inherited = new TreeSet<String>(Arrays.asList(user.getInheritedPermissions()));
                Result.access$202(result, session.security().getCurrentLoginStack());
                if (result.loginStack.length <= 1) {
                    Result.access$202(result, null);
                }
                Result.access$302(result, groups.toArray(new String[0]));
                if (result.groups.length == 0) {
                    Result.access$302(result, null);
                }
                if (!"admin".equals(login)) {
                    if (!rights.isEmpty()) {
                        Result.access$402(result, rights.toArray(new String[0]));
                        if (result.rights.length == 0) {
                            Result.access$402(result, null);
                        }
                    }
                    Result.access$502(result, inherited.toArray(new String[0]));
                    if (result.inherited.length == 0) {
                        Result.access$502(result, null);
                    }
                } else {
                    Result.access$402(result, new String[]{"ALL"});
                }
                if (user.getRemoteIdentity() != null) {
                    result.remoteId = user.getRemoteIdentity();
                }
                ArrayList<RepoResult> rr = new ArrayList<RepoResult>();
                for (NutsRepository repository : context.getSession().repos().getRepositories()) {
                    NutsUser ruser = repository.security().getEffectiveUser(login);
                    if (ruser == null || ruser.getGroups().length <= 0 && ruser.getPermissions().length <= 0 && NutsBlankable.isBlank((String)ruser.getRemoteIdentity())) continue;
                    RepoResult rt = new RepoResult();
                    rr.add(rt);
                    rt.name = repository.getName();
                    TreeSet<String> rgroups = new TreeSet<String>(Arrays.asList(ruser.getGroups()));
                    TreeSet<String> rrights = new TreeSet<String>(Arrays.asList(ruser.getPermissions()));
                    TreeSet<String> rinherited = new TreeSet<String>(Arrays.asList(ruser.getInheritedPermissions()));
                    if (!rgroups.isEmpty()) {
                        RepoResult.access$902(rt, rgroups.toArray(new String[0]));
                    }
                    if (!"admin".equals(login)) {
                        if (!rrights.isEmpty()) {
                            RepoResult.access$1002(rt, rrights.toArray(new String[0]));
                        }
                        if (!rinherited.isEmpty()) {
                            RepoResult.access$1102(rt, rinherited.toArray(new String[0]));
                        }
                    } else {
                        RepoResult.access$1002(rt, new String[]{"ALL"});
                    }
                    if (ruser.getRemoteIdentity() == null) continue;
                    rt.remoteId = ruser.getRemoteIdentity();
                }
                Result.access$1302(result, rr.isEmpty() ? null : rr.toArray(new RepoResult[0]));
            }
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                NutsPrintStream out = context.getSession().out();
                out.printf("%s\n", new Object[]{result.login});
                if (!options.nutsUser) break;
                NutsTexts factory = NutsTexts.of((NutsSession)context.getSession());
                if (result.loginStack != null) {
                    out.printf("%s      :", new Object[]{factory.ofStyled("stack", NutsTextStyle.primary5())});
                    for (String log : result.loginStack) {
                        out.printf(" %s", new Object[]{factory.ofStyled(log, NutsTextStyle.primary3())});
                    }
                    out.println();
                }
                if (result.groups != null && result.groups.length > 0) {
                    out.printf("%s : %s\n", new Object[]{factory.ofStyled("identities", NutsTextStyle.primary5()), Arrays.toString(result.groups)});
                }
                if (result.rights != null && result.rights.length > 0) {
                    out.printf("%s     : %s\n", new Object[]{factory.ofStyled("rights", NutsTextStyle.primary5()), Arrays.toString(result.rights)});
                }
                if (result.inherited != null && result.inherited.length > 0) {
                    out.printf("%s  : %s\n", new Object[]{factory.ofStyled("inherited", NutsTextStyle.primary5()), Arrays.toString(result.inherited)});
                } else {
                    out.printf("%s  : %s\n", new Object[]{factory.ofStyled("inherited", NutsTextStyle.primary5()), "NONE"});
                }
                if (result.remoteId != null) {
                    out.printf("%s  : %s\n", new Object[]{factory.ofStyled("remote-id", NutsTextStyle.primary5()), result.remoteId});
                }
                if (result.repos == null) break;
                for (RepoResult repo : result.repos) {
                    out.printf("[ %s ]: \n", new Object[]{factory.ofStyled(repo.name, NutsTextStyle.primary4())});
                    if (repo.identities.length > 0) {
                        out.printf("    %s : %s\n", new Object[]{factory.ofStyled("identities", NutsTextStyle.primary5()), Arrays.toString(repo.identities)});
                    }
                    if (result.rights != null && repo.rights.length > 0) {
                        out.printf("    %s     : %s\n", new Object[]{factory.ofStyled("rights", NutsTextStyle.primary5()), Arrays.toString(repo.rights)});
                    }
                    if (repo.inherited != null && repo.inherited.length > 0) {
                        out.printf("    %s  : %s\n", new Object[]{factory.ofStyled("inherited", NutsTextStyle.primary5()), Arrays.toString(repo.inherited)});
                    }
                    if (repo.remoteId == null) continue;
                    out.printf("    %s  : %s\n", new Object[]{factory.ofStyled("remote-id", NutsTextStyle.primary5()), repo.remoteId});
                }
                break;
            }
            default: {
                context.getSession().out().printlnf((Object)result);
            }
        }
    }

    private static class Result {
        private String login;
        private String[] loginStack;
        private String[] groups;
        private String[] rights;
        private String[] inherited;
        private String remoteId;
        private RepoResult[] repos;

        private Result() {
        }

        static /* synthetic */ String[] access$202(Result x0, String[] x1) {
            x0.loginStack = x1;
            return x1;
        }

        static /* synthetic */ String[] access$302(Result x0, String[] x1) {
            x0.groups = x1;
            return x1;
        }

        static /* synthetic */ String[] access$402(Result x0, String[] x1) {
            x0.rights = x1;
            return x1;
        }

        static /* synthetic */ String[] access$502(Result x0, String[] x1) {
            x0.inherited = x1;
            return x1;
        }

        static /* synthetic */ RepoResult[] access$1302(Result x0, RepoResult[] x1) {
            x0.repos = x1;
            return x1;
        }
    }

    private static class RepoResult {
        private String name;
        private String[] identities;
        private String[] rights;
        private String[] inherited;
        private String remoteId;

        private RepoResult() {
        }

        static /* synthetic */ String[] access$902(RepoResult x0, String[] x1) {
            x0.identities = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1002(RepoResult x0, String[] x1) {
            x0.rights = x1;
            return x1;
        }

        static /* synthetic */ String[] access$1102(RepoResult x0, String[] x1) {
            x0.inherited = x1;
            return x1;
        }
    }

    private static class Options {
        boolean argAll = false;
        boolean nutsUser = false;

        private Options() {
        }
    }
}

