/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class WgetCommand
extends SimpleJShellBuiltin {
    public WgetCommand() {
        super("wget", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"-O", "--output-document"}) != null) {
            options.outputDocument = commandLine.requireNonOption().next().getString();
            return true;
        }
        if (!commandLine.peek().isOption()) {
            while (commandLine.hasNext()) {
                options.files.add(commandLine.next().getString());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.isEmpty()) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"wget: Missing Files", (Object[])new Object[0]), 2);
        }
        for (String file : options.files) {
            this.download(file, options.outputDocument, context);
        }
    }

    protected void download(String path, String output, JShellExecutionContext context) {
        String output2 = output;
        NutsSession session = context.getSession();
        String urlName = NutsPath.of((String)path, (NutsSession)session).getName();
        if (!NutsBlankable.isBlank((String)output2)) {
            output2 = output2.replace("{}", urlName);
        }
        NutsPath file = NutsPath.of((String)context.getShellContext().getAbsolutePath(NutsBlankable.isBlank((String)output2) ? urlName : output2), (NutsSession)session);
        NutsCp.of((NutsSession)session).from(NutsPath.of((String)path, (NutsSession)session)).to(file).setSession(session).addOptions(new NutsPathOption[]{NutsPathOption.LOG, NutsPathOption.TRACE}).run();
    }

    private static class Options {
        String outputDocument = null;
        List<String> files = new ArrayList<String>();

        private Options() {
        }
    }
}

