/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import net.thevpc.nuts.NutsArchFamily;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class UnameCommand
extends SimpleJShellBuiltin {
    public UnameCommand() {
        super("uname", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options config = (Options)context.getOptions();
        switch (cmdLine.peek().getKey().getString()) {
            case "-m": {
                config.farch = true;
                return true;
            }
            case "-r": {
                config.fos = true;
                return true;
            }
            case "-d": {
                config.fdist = true;
                return true;
            }
            case "-a": {
                config.fdist = true;
                config.fos = true;
                config.farch = true;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options config = (Options)context.getOptions();
        NutsSession ws = context.getSession();
        Result rr = new Result();
        rr.osDist = ws.env().getOsDist();
        rr.os = ws.env().getOs();
        rr.arch = ws.env().getArchFamily();
        if (!(config.farch || config.fos || config.fdist)) {
            config.farch = true;
            config.fos = true;
            config.fdist = true;
        }
        if (!config.farch && rr.arch != null) {
            rr.arch = null;
        }
        if (!config.fos && rr.os != null) {
            rr.os = null;
        }
        if (!config.fdist && rr.osDist != null) {
            rr.osDist = null;
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                ArrayList<String> sb = new ArrayList<String>();
                if (rr.arch != null) {
                    sb.add(rr.arch.toString());
                }
                if (rr.os != null) {
                    sb.add(rr.os.toString());
                }
                if (rr.osDist != null) {
                    sb.add(rr.osDist.toString());
                }
                if (sb.isEmpty()) {
                    sb.add("UNKNOWN");
                }
                context.getSession().out().println(String.join((CharSequence)" ", sb));
                break;
            }
            default: {
                context.getSession().out().printlnf((Object)rr);
            }
        }
    }

    private static class Result {
        NutsId osDist;
        NutsId os;
        NutsArchFamily arch;

        private Result() {
        }
    }

    private static class Options {
        boolean farch = false;
        boolean fos = false;
        boolean fdist = false;

        private Options() {
        }
    }
}

