/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandType;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class TypeCommand
extends SimpleJShellBuiltin {
    public TypeCommand() {
        super("type", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options config = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isNonOption()) {
            config.commands.add(commandLine.next().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options config = (Options)context.getOptions();
        JShell shell = context.getShell();
        ArrayList<ResultItem> result = new ArrayList<ResultItem>();
        for (String cmd : config.commands) {
            JShellBuiltin ic = context.getShellContext().builtins().find(cmd);
            if (ic != null && ic.isEnabled()) {
                result.add(new ResultItem(cmd, "builtin", cmd + " is a shell builtin"));
                continue;
            }
            String alias = context.getShellContext().aliases().get(cmd);
            if (alias != null) {
                result.add(new ResultItem(cmd, "alias", cmd + " is aliased to `" + alias + "`"));
                continue;
            }
            JShellCommandType pp = shell.getCommandTypeResolver().type(cmd, context.getShellContext());
            if (pp != null) {
                result.add(new ResultItem(cmd, pp.getType(), pp.getDescription()));
                continue;
            }
            if (ic != null) {
                result.add(new ResultItem(cmd, "error", cmd + " is disabled"));
                continue;
            }
            result.add(new ResultItem(cmd, "error", cmd + " not found"));
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                for (ResultItem resultItem : result) {
                    context.getSession().out().println(resultItem.message);
                }
                break;
            }
            default: {
                context.getSession().out().printlnf(result);
            }
        }
    }

    private static class ResultItem {
        String command;
        String type;
        String message;

        public ResultItem(String command, String type, String message) {
            this.command = command;
            this.type = type;
            this.message = message;
        }

        public ResultItem() {
        }
    }

    private static class Options {
        List<String> commands = new ArrayList<String>();

        private Options() {
        }
    }
}

