/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class SourceCommand
extends SimpleJShellBuiltin {
    public SourceCommand() {
        super("source", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (!a.isOption()) {
            options.args.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (options.args.isEmpty()) {
            this.throwExecutionException("missing command", 1, session);
        }
        String[] paths = context.getShellContext().vars().get("PATH", "").split(":|;");
        NutsPath goodFile = null;
        String file = options.args.remove(0);
        NutsPath file0 = NutsPath.of((String)file, (NutsSession)session);
        boolean found = false;
        if (file0.isName()) {
            for (String path : paths) {
                NutsPath basePathFolder = NutsPath.of((String)path, (NutsSession)session);
                if (!basePathFolder.resolve(file0).isRegularFile()) continue;
                file = basePathFolder.resolve(file).toString();
                break;
            }
        }
        if (!NutsPath.of((String)file, (NutsSession)session).isFile() && NutsPath.of((String)context.getShellContext().getCwd(), (NutsSession)session).resolve(file).isRegularFile()) {
            file = NutsPath.of((String)context.getShellContext().getCwd(), (NutsSession)session).resolve(file).toString();
        }
        if (!NutsPath.of((String)file, (NutsSession)session).isRegularFile()) {
            this.throwExecutionException("file not found", 1, session);
        } else {
            goodFile = NutsPath.of((String)file, (NutsSession)session);
            JShellContext c2 = context.getShellContext();
            JShellContext c = context.getShell().createInlineContext(c2, goodFile.toString(), options.args.toArray(new String[0]));
            context.getShell().executeServiceFile(c, false);
        }
    }

    private static class Options {
        List<String> args = new ArrayList<String>();

        private Options() {
        }
    }
}

