/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellResult;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ShowerrCommand
extends SimpleJShellBuiltin {
    public ShowerrCommand() {
        super("showerr", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (!a.isOption()) {
            NutsSession session = context.getSession();
            if (options.login == null) {
                options.login = commandLine.next(NutsArgumentName.of((String)"username", (NutsSession)session)).getString();
                return true;
            }
            if (options.password == null) {
                options.password = commandLine.next(NutsArgumentName.of((String)"password", (NutsSession)session)).getString().toCharArray();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        JShellResult r = context.getShellContext().getLastResult();
        NutsPrintStream out = context.getSession().out();
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                if (r.getCode() == 0) {
                    out.println((NutsString)NutsTexts.of((NutsSession)context.getSession()).ofStyled("last command ended successfully with no errors.", NutsTextStyle.success()));
                    break;
                }
                out.println((NutsString)NutsTexts.of((NutsSession)context.getSession()).ofStyled("last command ended abnormally with the following error :", NutsTextStyle.error()));
                if (r.getMessage() != null) {
                    out.println((NutsString)NutsTexts.of((NutsSession)context.getSession()).ofStyled(r.getMessage(), NutsTextStyle.error()));
                }
                if (r.getStackTrace() == null) break;
                context.err().println((NutsString)NutsTexts.of((NutsSession)context.getSession()).ofStyled(r.getStackTrace(), NutsTextStyle.error()));
                break;
            }
            default: {
                out.printlnf((Object)r);
            }
        }
    }

    private static class Options {
        String login;
        char[] password;

        private Options() {
        }
    }
}

