/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class RmCommand
extends SimpleJShellBuiltin {
    public RmCommand() {
        super("rm", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextBoolean(new String[]{"-R"});
        if (a != null) {
            options.R = a.getBooleanValue();
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            options.files.add(ShellHelper.xfileOf(commandLine.next().getString(), context.getShellContext().getCwd(), context.getSession()));
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.size() < 1) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"missing parameters", (Object[])new Object[0]), 2);
        }
        for (NutsPath p : options.files) {
            if (options.R) {
                p.deleteTree();
                continue;
            }
            p.delete();
        }
    }

    public static class Options {
        boolean R = false;
        boolean verbose = false;
        List<NutsPath> files = new ArrayList<NutsPath>();
    }
}

