/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsObjectFormat;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

public class PropsCommand
extends SimpleJShellBuiltin {
    public PropsCommand() {
        super("props", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        NutsSession session = context.getSession();
        if (commandLine.next(new String[]{"get"}) != null) {
            o.property = commandLine.next().getString();
            o.action = "get";
            while (commandLine.hasNext()) {
                if (commandLine.next(new String[]{"--xml"}) != null) {
                    o.sourceFormat = Format.XML;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--system"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.SYSTEM;
                    o.sourceFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--props"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--file"}) != null) {
                    o.sourceFormat = Format.AUTO;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                commandLine.setCommandName(this.getName()).unexpectedArgument();
            }
            return true;
        }
        if (commandLine.next(new String[]{"set"}) != null) {
            String k = commandLine.next().getString();
            String v = commandLine.next().getString();
            o.updates.put(k, v);
            o.action = "set";
            while (commandLine.hasNext()) {
                if (commandLine.next(new String[]{"--comments"}) != null) {
                    o.comments = commandLine.next().getValue().getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--to-props-file"}) != null) {
                    o.targetFormat = Format.PROPS;
                    o.targetType = TargetType.FILE;
                    o.targetFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--to-xml-file"}) != null) {
                    o.targetFormat = Format.XML;
                    o.targetType = TargetType.FILE;
                    o.targetFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--to-file"}) != null) {
                    o.targetFormat = Format.AUTO;
                    o.targetType = TargetType.FILE;
                    o.targetFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--print-props"}) != null) {
                    o.targetFormat = Format.PROPS;
                    o.targetType = TargetType.CONSOLE;
                    o.targetFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--print-xml"}) != null) {
                    o.targetFormat = Format.XML;
                    o.targetType = TargetType.CONSOLE;
                    o.targetFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--save"}) != null) {
                    o.targetFormat = Format.AUTO;
                    o.targetType = TargetType.CONSOLE;
                    o.targetFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--sort"}) != null) {
                    o.sort = true;
                    session.addOutputFormatOptions(new String[]{"--sort"});
                    continue;
                }
                if (commandLine.next(new String[]{"--xml"}) != null) {
                    o.sourceFormat = Format.XML;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--system"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.SYSTEM;
                    o.sourceFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--props"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--file"}) != null) {
                    o.sourceFormat = Format.AUTO;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                commandLine.setCommandName(this.getName()).unexpectedArgument();
            }
            return true;
        }
        if (commandLine.next(new String[]{"list"}) != null) {
            o.action = "list";
            while (commandLine.hasNext()) {
                if (commandLine.next(new String[]{"--xml"}) != null) {
                    o.sourceFormat = Format.XML;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--system"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.SYSTEM;
                    o.sourceFile = null;
                    continue;
                }
                if (commandLine.next(new String[]{"--props"}) != null) {
                    o.sourceFormat = Format.PROPS;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--file"}) != null) {
                    o.sourceFormat = Format.AUTO;
                    o.sourceType = SourceType.FILE;
                    o.sourceFile = commandLine.required().nextNonOption(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
                    continue;
                }
                if (commandLine.next(new String[]{"--sort"}) != null) {
                    o.sort = true;
                    session.addOutputFormatOptions(new String[]{"--sort"});
                    continue;
                }
                commandLine.setCommandName(this.getName()).unexpectedArgument();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options o = (Options)context.getOptions();
        NutsSession session = context.getSession();
        commandLine.setCommandName(this.getName());
        if (o.sourceType != SourceType.FILE && o.sourceFile != null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"props: Should not use file with --system flag", (Object[])new Object[0]), 2);
        }
        if (o.sourceType == SourceType.FILE && o.sourceFile == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"props: Missing file", (Object[])new Object[0]), 3);
        }
        if (o.action == null) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"props: Missing action", (Object[])new Object[0]), 4);
        }
        switch (o.action) {
            case "get": {
                this.action_get(context, o);
                return;
            }
            case "set": {
                Map<String, String> p = this.getProperties(o, context);
                try {
                    for (Map.Entry<String, String> e : o.updates.entrySet()) {
                        p.put(e.getKey(), e.getValue());
                    }
                    this.storeProperties(p, o, context);
                }
                catch (Exception ex) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
                }
                return;
            }
            case "list": {
                this.action_list(context, o);
                return;
            }
        }
        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"props: Unsupported action %s", (Object[])new Object[]{o.action}), 2);
    }

    @Override
    public String getHelpHeader() {
        return "show properties vars";
    }

    private void action_list(JShellExecutionContext context, Options o) {
        NutsObjectFormat.of((NutsSession)context.getSession()).setValue(this.getProperties(o, context)).print();
    }

    private int action_get(JShellExecutionContext context, Options o) {
        Map<String, String> p = this.getProperties(o, context);
        String v = p.get(o.property);
        NutsObjectFormat.of((NutsSession)context.getSession()).setValue((Object)(v == null ? "" : v)).print();
        return 0;
    }

    private Map<String, String> getProperties(Options o, JShellExecutionContext context) {
        AbstractMap p = o.sort ? new TreeMap() : new HashMap();
        switch (o.sourceType) {
            case FILE: {
                p.putAll(this.readProperties(o, context));
                break;
            }
            case SYSTEM: {
                p = new TreeMap<Object, Object>(System.getProperties());
            }
        }
        return p;
    }

    private Format detectFileFormat(String file, JShellExecutionContext context) {
        if (file.toLowerCase().endsWith(".props") || file.toLowerCase().endsWith(".properties")) {
            return Format.PROPS;
        }
        if (file.toLowerCase().endsWith(".xml")) {
            return Format.XML;
        }
        throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"unknown file format %s", (Object[])new Object[]{file}), 2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> readProperties(Options o, JShellExecutionContext context) {
        LinkedHashMap<String, String> p = new LinkedHashMap<String, String>();
        String sourceFile = o.sourceFile;
        NutsPath filePath = ShellHelper.xfileOf(sourceFile, context.getShellContext().getCwd(), context.getSession());
        try (InputStream is = filePath.getInputStream();){
            Format sourceFormat = o.sourceFormat;
            if (sourceFormat == Format.AUTO) {
                sourceFormat = this.detectFileFormat(filePath.getName(), context);
            }
            switch (sourceFormat) {
                case PROPS: {
                    Properties pp = new Properties();
                    pp.load(is);
                    p.putAll(pp);
                    return p;
                }
                case XML: {
                    Properties pp = new Properties();
                    pp.loadFromXML(is);
                    p.putAll(pp);
                    return p;
                }
            }
            return p;
        }
        catch (Exception ex) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeProperties(Map<String, String> p, Options o, JShellExecutionContext context) throws IOException {
        String targetFile = o.targetFile;
        boolean console = false;
        switch (o.targetType) {
            case AUTO: {
                if (targetFile != null) break;
                targetFile = o.sourceFile;
                break;
            }
            case CONSOLE: {
                console = true;
                break;
            }
        }
        NutsSession session = context.getSession();
        if (console) {
            Format format = o.targetFormat;
            switch (format) {
                case AUTO: {
                    NutsObjectFormat f = NutsObjectFormat.of((NutsSession)session).setValue(p);
                    f.configure(true, session.boot().getBootOptions().getOutputFormatOptions());
                    f.configure(true, session.getOutputFormatOptions());
                    f.println(session.out());
                    return;
                }
                case PROPS: {
                    if (o.sort && !(p instanceof SortedMap)) {
                        p = new TreeMap<String, String>(p);
                    }
                    new OrderedProperties(p).store(context.out().asPrintStream(), o.comments);
                    return;
                }
                case XML: {
                    if (o.sort && !(p instanceof SortedMap)) {
                        p = new TreeMap<String, String>(p);
                    }
                    new OrderedProperties(p).storeToXML(context.out().asPrintStream(), o.comments);
                    return;
                }
            }
            return;
        }
        NutsPath filePath = ShellHelper.xfileOf(targetFile, context.getShellContext().getCwd(), session);
        try (OutputStream os = filePath.getOutputStream();){
            Format format = o.targetFormat;
            if (format == Format.AUTO) {
                format = this.detectFileFormat(filePath.getName(), null);
            }
            switch (format) {
                case PROPS: {
                    if (o.sort && !(p instanceof SortedMap)) {
                        p = new TreeMap<String, String>(p);
                    }
                    new OrderedProperties(p).store(os, o.comments);
                    return;
                }
                case XML: {
                    if (o.sort && !(p instanceof SortedMap)) {
                        p = new TreeMap<String, String>(p);
                    }
                    new OrderedProperties(p).storeToXML(os, o.comments);
                    return;
                }
            }
            return;
        }
    }

    private static class OrderedProperties
    extends Properties {
        private Map<String, String> other;

        public OrderedProperties(Map<String, String> other) {
            this.putAll(other);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(this.other.keySet());
        }
    }

    private static class SortedProperties
    extends Properties {
        public SortedProperties(Properties other) {
            this.putAll((Map<?, ?>)other);
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            return Collections.enumeration(new TreeSet<Object>(super.keySet()));
        }
    }

    public static class Options {
        String property = null;
        String action = null;
        Format sourceFormat = Format.AUTO;
        String sourceFile = null;
        String targetFile = null;
        Format targetFormat = Format.AUTO;
        boolean sort = false;
        Map<String, String> updates = new HashMap<String, String>();
        SourceType sourceType = SourceType.FILE;
        TargetType targetType = TargetType.FILE;
        String comments;
    }

    public static enum Format {
        PROPS,
        XML,
        AUTO;

    }

    public static enum TargetType {
        AUTO,
        FILE,
        CONSOLE;

    }

    public static enum SourceType {
        FILE,
        SYSTEM;

    }
}

