/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class MkdirCommand
extends SimpleJShellBuiltin {
    public MkdirCommand() {
        super("mkdir", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextBoolean(new String[]{"--parent", "-p"});
        if (a != null) {
            options.p = a.getBooleanValue();
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            options.files.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        options.xfiles = ShellHelper.xfilesOf(options.files, context.getShellContext().getCwd(), context.getSession());
        if (options.xfiles.size() < 1) {
            commandLine.required();
        }
        for (NutsPath v : options.xfiles) {
            if (options.p) {
                v.mkdirs();
                continue;
            }
            v.mkdir();
        }
    }

    public static class Options {
        List<String> files = new ArrayList<String>();
        List<NutsPath> xfiles = new ArrayList<NutsPath>();
        boolean p;
    }
}

