/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsComparator;
import net.thevpc.nuts.NutsElement;
import net.thevpc.nuts.NutsElements;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles.BytesSizeFormat;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class LsCommand
extends SimpleJShellBuiltin {
    private static final FileSorter FILE_SORTER = new FileSorter();
    private final HashSet<String> fileTypeArchive = new HashSet<String>(Arrays.asList("jar", "war", "ear", "rar", "zip", "tar", "gz"));
    private final HashSet<String> fileTypeExec2 = new HashSet<String>(Arrays.asList("jar", "war", "ear", "rar", "zip", "bin", "exe", "tar", "gz", "class", "sh"));
    private final HashSet<String> fileTypeConfig = new HashSet<String>(Arrays.asList("xml", "config", "cfg", "json", "iml", "ipr"));
    private final DateTimeFormatter SIMPLE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").withZone(ZoneId.systemDefault());

    public LsCommand() {
        super("ls", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextBoolean(new String[]{"-d", "--dir"});
        if (a != null) {
            options.d = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-l", "--list"});
        if (a != null) {
            options.l = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-a", "--all"});
        if (a != null) {
            options.a = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-h"});
        if (a != null) {
            options.h = a.getBooleanValue();
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            NutsSession session = context.getSession();
            String path = commandLine.next(NutsArgumentName.of((String)"file", (NutsSession)session)).getString();
            options.paths.add(path);
            options.paths.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skip();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        ResultGroup g;
        NutsPath file;
        Options options = (Options)context.getOptions();
        ResultSuccess success = new ResultSuccess();
        success.workingDir = context.getShellContext().getAbsolutePath(".");
        ResultError errors = null;
        int exitCode = 0;
        if (options.paths.isEmpty()) {
            options.paths.add(context.getShellContext().getAbsolutePath("."));
        }
        NutsSession session = context.getSession();
        LinkedHashMap<NutsPath, ResultGroup> filesTodos = new LinkedHashMap<NutsPath, ResultGroup>();
        LinkedHashMap<NutsPath, ResultGroup> foldersTodos = new LinkedHashMap<NutsPath, ResultGroup>();
        for (String string : options.paths) {
            if (NutsBlankable.isBlank((String)string)) {
                if (errors == null) {
                    errors = new ResultError();
                    errors.workingDir = context.getShellContext().getAbsolutePath(".");
                }
                errors.result.put(string, NutsMessage.cstyle((String)"cannot access '%s': No such file or directory", (Object[])new Object[]{string}));
                continue;
            }
            file = NutsPath.of((String)string, (NutsSession)session);
            if (file == null) {
                if (errors == null) {
                    errors = new ResultError();
                    errors.workingDir = context.getShellContext().getAbsolutePath(".");
                }
                errors.result.put(string, NutsMessage.cstyle((String)"cannot access '%s': No such file or directory", (Object[])new Object[]{string}));
                continue;
            }
            if (!(file = file.toAbsolute(NutsPath.of((String)context.getShellContext().getCwd(), (NutsSession)session))).exists()) {
                exitCode = 1;
                if (errors == null) {
                    errors = new ResultError();
                    errors.workingDir = context.getShellContext().getAbsolutePath(".");
                }
                errors.result.put(string, NutsMessage.cstyle((String)"cannot access '%s': No such file or directory", (Object[])new Object[]{file}));
                continue;
            }
            g = new ResultGroup();
            g.name = string;
            if (!file.isDirectory() || options.d) {
                filesTodos.put(file, g);
                continue;
            }
            foldersTodos.put(file, g);
        }
        for (Map.Entry entry : filesTodos.entrySet()) {
            file = (NutsPath)entry.getKey();
            g = (ResultGroup)entry.getValue();
            g.file = this.build(file);
            success.result.add(g);
        }
        for (Map.Entry entry : foldersTodos.entrySet()) {
            file = (NutsPath)entry.getKey();
            g = (ResultGroup)entry.getValue();
            g.children = file.list().sorted((NutsComparator)FILE_SORTER).map(this::build, "build").filter(b -> options.a || !b.hidden, "all || !hidden").toList();
            success.result.add(g);
        }
        if (success != null) {
            NutsPrintStream out = session.out();
            switch (session.getOutputFormat()) {
                case XML: 
                case JSON: 
                case YAML: 
                case TREE: 
                case TSON: 
                case PROPS: {
                    out.printlnf(success.result.stream().collect(Collectors.toMap(x -> x.name, x -> x.children)));
                    break;
                }
                case TABLE: {
                    out.printlnf(success.result.stream().flatMap(x -> x.children == null ? Stream.empty() : x.children.stream().map(y -> {
                        Map m = (Map)NutsElements.of((NutsSession)session).destruct(y);
                        m.put("group", x.name);
                        return m;
                    })).collect(Collectors.toList()));
                    break;
                }
                case PLAIN: {
                    boolean bl = true;
                    for (ResultGroup resultGroup : success.result) {
                        boolean bl2;
                        void wasFirst = bl2;
                        bl2 = false;
                        if (resultGroup.children != null) {
                            if (wasFirst == false) {
                                out.println();
                            }
                            if (options.paths.size() > 1) {
                                out.printf("%s:\n", new Object[]{resultGroup.name});
                            }
                            for (ResultItem resultItem : resultGroup.children) {
                                this.printPlain(resultItem, options, out, session);
                            }
                            continue;
                        }
                        this.printPlain(resultGroup.file, options, out, session);
                    }
                    break;
                }
            }
        }
        if (errors != null) {
            this.throwExecutionException(errors.result, exitCode, session);
        }
    }

    private void printPlain(ResultItem item, Options options, NutsPrintStream out, NutsSession session) {
        if (options.l) {
            out.printf("%s%s  %s %s %s %s ", new Object[]{Character.valueOf(item.type), item.uperms != null ? item.uperms : item.jperms, NutsUtilStrings.trim((String)item.owner), NutsUtilStrings.trim((String)item.group), options.h ? options.byteFormat.format(item.length) : String.format("%9d", item.length), item.modified == null ? "" : this.SIMPLE_DATE_FORMAT.format(item.modified)});
        }
        String name = NutsPath.of((String)item.path, (NutsSession)session).getName();
        NutsTexts text = NutsTexts.of((NutsSession)session);
        if (item.hidden) {
            out.println((NutsString)text.ofStyled(name, NutsTextStyle.pale()));
        } else if (item.type == 'd') {
            out.println((NutsString)text.ofStyled(name, NutsTextStyle.primary3()));
        } else if (item.exec2 || item.jperms.charAt(2) == 'x') {
            out.println((NutsString)text.ofStyled(name, NutsTextStyle.primary4()));
        } else if (item.config) {
            out.println((NutsString)text.ofStyled(name, NutsTextStyle.primary5()));
        } else if (item.archive) {
            out.println((NutsString)text.ofStyled(name, NutsTextStyle.primary1()));
        } else {
            out.println((NutsString)text.ofPlain(name));
        }
    }

    private ResultItem build(NutsPath path) {
        ResultItem r = new ResultItem();
        r.path = path.toString();
        r.name = path.getName();
        boolean dir = path.isDirectory();
        boolean regular = path.isRegularFile();
        boolean link = path.isSymbolicLink();
        boolean other = false;
        Set permissions = path.getPermissions();
        r.jperms = (permissions.contains(NutsPathPermission.CAN_READ) ? "r" : "-") + (permissions.contains(NutsPathPermission.CAN_WRITE) ? "w" : "-") + (permissions.contains(NutsPathPermission.CAN_EXECUTE) ? "x" : "-");
        r.owner = path.owner();
        r.group = path.group();
        r.modified = path.getLastModifiedInstant();
        r.created = path.getCreationInstant();
        r.accessed = path.getLastAccessInstant();
        other = path.isOther();
        r.length = path.getContentLength();
        char[] perms = new char[]{permissions.contains(NutsPathPermission.OWNER_READ) ? (char)'r' : '-', permissions.contains(NutsPathPermission.OWNER_WRITE) ? (char)'w' : '-', permissions.contains(NutsPathPermission.OWNER_EXECUTE) ? (char)'x' : '-', permissions.contains(NutsPathPermission.GROUP_READ) ? (char)'r' : '-', permissions.contains(NutsPathPermission.GROUP_WRITE) ? (char)'w' : '-', permissions.contains(NutsPathPermission.GROUP_EXECUTE) ? (char)'x' : '-', permissions.contains(NutsPathPermission.OTHERS_READ) ? (char)'r' : '-', permissions.contains(NutsPathPermission.OTHERS_WRITE) ? (char)'w' : '-', permissions.contains(NutsPathPermission.OTHERS_EXECUTE) ? (char)'x' : '-'};
        r.uperms = new String(perms);
        String p = path.getName().toLowerCase();
        if (!dir) {
            if (p.startsWith(".") || p.endsWith(".log") || p.contains(".log.")) {
                r.hidden = true;
            } else {
                int i = p.lastIndexOf(46);
                if (i > -1) {
                    String suffix = p.substring(i + 1);
                    if (this.fileTypeConfig.contains(suffix)) {
                        r.config = true;
                    }
                    if (this.fileTypeArchive.contains(suffix)) {
                        r.archive = true;
                    }
                    if (this.fileTypeExec2.contains(suffix)) {
                        r.exec2 = true;
                    }
                }
            }
        } else if (p.startsWith(".")) {
            r.hidden = true;
        }
        r.type = (char)(dir ? 100 : (regular ? 45 : (link ? 108 : (other ? 111 : 63))));
        return r;
    }

    private static class FileSorter
    implements NutsComparator<NutsPath> {
        boolean foldersFirst = true;
        boolean groupCase = true;

        private FileSorter() {
        }

        public int compare(NutsPath o1, NutsPath o2) {
            int d1;
            int n = o1.isDirectory() ? 0 : (d1 = o1.isRegularFile() ? 1 : 2);
            int d2 = o2.isDirectory() ? 0 : (o2.isRegularFile() ? 1 : 2);
            int x = 0;
            if (this.foldersFirst && (x = d1 - d2) != 0) {
                return x;
            }
            if (this.groupCase && (x = o1.toString().toLowerCase().compareTo(o2.toString().toLowerCase())) != 0) {
                return x;
            }
            x = o1.toString().compareTo(o2.toString());
            return x;
        }

        public NutsElement describe(NutsElements elems) {
            return elems.ofString("foldersFirst");
        }
    }

    public static class ResultItem {
        String name;
        String path;
        char type;
        String uperms;
        String jperms;
        String owner;
        String group;
        long length;
        Instant modified;
        Instant created;
        Instant accessed;
        boolean config;
        boolean exec2;
        boolean archive;
        boolean hidden;
    }

    public static class ResultGroup {
        String name;
        ResultItem file;
        List<ResultItem> children;
    }

    public static class ResultError {
        boolean error = true;
        String workingDir;
        Map<String, NutsMessage> result = new HashMap<String, NutsMessage>();
    }

    private static class ResultSuccess {
        String workingDir;
        List<ResultGroup> result = new ArrayList<ResultGroup>();

        private ResultSuccess() {
        }
    }

    private static class Options {
        boolean a = false;
        boolean d = false;
        boolean l = false;
        boolean h = false;
        List<String> paths = new ArrayList<String>();
        BytesSizeFormat byteFormat = new BytesSizeFormat("iD1F");

        private Options() {
        }
    }
}

