/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsOsFamily;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class JpsCommand
extends SimpleJShellBuiltin {
    public JpsCommand() {
        super("jps", 10, Options.class);
    }

    public static String resolveJpsCommand(NutsSession session) {
        return JpsCommand.resolveJavaToolCommand(session, null, "jps");
    }

    public static String resolveJavaToolCommand(NutsSession session, String javaHome, String javaCommand) {
        Path jh;
        Path p;
        String exe;
        String string = exe = session.env().getOsFamily().equals((Object)NutsOsFamily.WINDOWS) ? javaCommand + ".exe" : javaCommand;
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        if (Files.exists(p = (jh = Paths.get(javaHome, new String[0])).resolve("bin").resolve(exe), new LinkOption[0])) {
            return p.toString();
        }
        p = jh.resolve(exe);
        if (Files.exists(p, new LinkOption[0])) {
            return p.toString();
        }
        if (jh.getFileName().toString().equals("jre")) {
            p = jh.getParent().resolve("bin").resolve(exe);
            if (Files.exists(p, new LinkOption[0])) {
                return p.toString();
            }
            p = jh.getParent().resolve(exe);
            if (Files.exists(p, new LinkOption[0])) {
                return p.toString();
            }
        }
        return exe;
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"-l"}) != null) {
            options.l = true;
            return true;
        }
        if (commandLine.next(new String[]{"-v"}) != null) {
            options.v = true;
            return true;
        }
        if (commandLine.next(new String[]{"-m"}) != null) {
            options.m = true;
            return true;
        }
        if (commandLine.next(new String[]{"-q"}) != null) {
            options.q = true;
            return true;
        }
        if (commandLine.next(new String[]{"-V"}) != null) {
            options.v = true;
            return true;
        }
        if (!commandLine.peek().isOption() && options.host == null) {
            options.host = commandLine.next().toString();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        ArrayList<JpsRow> results = new ArrayList<JpsRow>();
        NutsExecCommand e = context.getSession().exec().setExecutionType(NutsExecutionType.SYSTEM).addCommand(new String[]{JpsCommand.resolveJpsCommand(context.getSession()), "-l", "-v", "-m"}).setRedirectErrorStream(true).grabOutputString().setFailFast(true).run();
        String resultString = e.getOutputString();
        for (String line : resultString.split("[\n\r]+")) {
            if ((line = line.trim()).length() <= 0) continue;
            int s1 = line.indexOf(32);
            int s2 = s1 <= 0 ? -1 : line.indexOf(32, s1 + 1);
            JpsRow r = new JpsRow();
            String string = r.id = s1 < 0 ? line : line.substring(0, s1);
            r.fullName = s1 <= 0 ? "" : (s2 <= 0 ? line.substring(s1 + 1).trim() : line.substring(s1 + 1, s2));
            r.arguments = s2 < 0 ? "" : line.substring(s2 + 1);
            String string2 = r.name = r.fullName.lastIndexOf(46) >= 0 ? r.fullName.substring(r.fullName.lastIndexOf(46) + 1) : r.fullName;
            if (options.q) {
                r.fullName = null;
                r.arguments = null;
            }
            if (!options.l) {
                r.fullName = null;
            }
            if (!options.m) {
                r.arguments = null;
            }
            if (!options.v) {
                r.vmOptions = null;
            }
            results.add(r);
        }
        context.getSession().out().printlnf(results);
    }

    private static class Options {
        boolean m = false;
        boolean v = false;
        boolean V = false;
        boolean q = false;
        boolean l = false;
        String host;

        private Options() {
        }
    }

    private static class JpsRow {
        String id;
        String name;
        String fullName;
        String vmOptions;
        String arguments;

        private JpsRow() {
        }
    }
}

