/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUnsupportedArgumentException;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellHistory;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class HistoryCommand
extends SimpleJShellBuiltin {
    public HistoryCommand() {
        super("history", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"-c", "--clear"}) != null) {
            options.action = Action.CLEAR;
            commandLine.setCommandName(this.getName()).unexpectedArgument();
            return true;
        }
        NutsArgument a = commandLine.nextString(new String[]{"-d", "--delete"});
        if (a != null) {
            options.action = Action.DELETE;
            options.ival = a.getValue().getInt();
            commandLine.setCommandName(this.getName()).unexpectedArgument();
            return true;
        }
        a = commandLine.next(new String[]{"-D", "--remove-duplicates"});
        if (a != null) {
            options.action = Action.REMOVE_DUPLICATES;
            commandLine.setCommandName(this.getName()).unexpectedArgument();
            return true;
        }
        a = commandLine.next(new String[]{"-w", "--write"});
        if (a != null) {
            options.action = Action.WRITE;
            if (a.isKeyValue()) {
                options.sval = a.getValue().getString();
            } else if (!commandLine.isEmpty()) {
                options.sval = commandLine.next().getString();
            }
            commandLine.setCommandName(this.getName()).unexpectedArgument();
            return true;
        }
        a = commandLine.next(new String[]{"-r", "--read"});
        if (a != null) {
            options.action = Action.READ;
            if (a.isKeyValue()) {
                options.sval = a.getValue().getString();
            } else if (!commandLine.isEmpty()) {
                options.sval = commandLine.next().getString();
            }
            commandLine.setCommandName(this.getName()).unexpectedArgument();
            return true;
        }
        if (commandLine.peek().toElement().getInt(Integer.valueOf(0)) != 0) {
            options.action = Action.PRINT;
            options.ival = Math.abs(commandLine.next().toElement().getInt());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        JShellHistory shistory = context.getShell().getHistory();
        NutsSession session = context.getSession();
        switch (options.action) {
            case PRINT: {
                List<String> history = shistory.getElements(options.ival <= 0 ? 1000 : options.ival);
                int offset = shistory.size() - history.size();
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (int i = 0; i < history.size(); ++i) {
                    String historyElement = history.get(i);
                    result.put(String.valueOf(offset + i + 1), historyElement);
                }
                session.out().printlnf(result);
                break;
            }
            case CLEAR: {
                shistory.clear();
                return;
            }
            case REMOVE_DUPLICATES: {
                shistory.removeDuplicates();
                return;
            }
            case DELETE: {
                shistory.remove(options.ival - 1);
                return;
            }
            case WRITE: {
                try {
                    if (options.sval == null) {
                        shistory.save();
                    } else {
                        shistory.save(NutsPath.of((String)options.sval, (NutsSession)session).toAbsolute(session.locations().getWorkspaceLocation()));
                    }
                }
                catch (IOException ex) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
                }
                return;
            }
            case READ: {
                try {
                    if (options.sval == null) {
                        shistory.clear();
                        shistory.load();
                    } else {
                        shistory.load(NutsPath.of((String)options.sval, (NutsSession)session).toAbsolute(session.locations().getWorkspaceLocation()));
                    }
                }
                catch (IOException ex) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
                }
                return;
            }
            default: {
                throw new NutsUnsupportedArgumentException(session, NutsMessage.cstyle((String)"unsupported %s", (Object[])new Object[]{String.valueOf((Object)options.action)}));
            }
        }
    }

    private static class Options {
        public String sval;
        int ival = -1;
        Action action = Action.PRINT;

        private Options() {
        }
    }

    private static enum Action {
        CLEAR,
        DELETE,
        REMOVE_DUPLICATES,
        WRITE,
        READ,
        PRINT;

    }
}

