/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import net.thevpc.nuts.NutsArgumentName;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles._StringUtils;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.options.CommandNonOption;

public class HelpCommand
extends SimpleJShellBuiltin {
    public HelpCommand() {
        super("help", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"--ntf"}) != null) {
            options.code = true;
            return true;
        }
        if (commandLine.peek().isNonOption()) {
            options.commandNames.add(commandLine.nextNonOption((NutsArgumentName)new CommandNonOption("command", context.getShellContext())).required().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Function<String, String> ss;
        Options options = (Options)context.getOptions();
        if (options.code) {
            context.getSession().getTerminal().setOut(context.getSession().getTerminal().out().setMode(NutsTerminalMode.INHERITED));
        }
        final NutsTexts text = NutsTexts.of((NutsSession)context.getSession());
        Function<String, String> function = ss = options.code ? new Function<String, String>(){

            @Override
            public String apply(String t) {
                return text.ofPlain(t).toString();
            }
        } : x -> x;
        if (commandLine.isExecMode()) {
            if (options.commandNames.isEmpty()) {
                NutsText n = text.parser().parseResource("/net/thevpc/nuts/toolbox/nsh.ntf", text.parser().createLoader(HelpCommand.class.getClassLoader()));
                String helpText = n == null ? "no help found" : n.toString();
                context.out().println((String)ss.apply(helpText));
                context.out().println((NutsString)NutsTexts.of((NutsSession)context.getSession()).ofStyled("AVAILABLE COMMANDS ARE:", NutsTextStyle.primary1()));
                JShellBuiltin[] commands = context.getShellContext().builtins().getAll();
                Arrays.sort(commands, new Comparator<JShellBuiltin>(){

                    @Override
                    public int compare(JShellBuiltin o1, JShellBuiltin o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                int max = 1;
                for (JShellBuiltin cmd : commands) {
                    int x2 = cmd.getName().length();
                    if (x2 <= max) continue;
                    max = x2;
                }
                for (JShellBuiltin cmd : commands) {
                    context.out().printf("%s : ", new Object[]{text.ofStyled(_StringUtils.formatLeft(cmd.getName(), max), NutsTextStyle.primary4())});
                    context.out().println((String)ss.apply(cmd.getHelpHeader()));
                }
            } else {
                int x3 = 0;
                for (String commandName : options.commandNames) {
                    JShellBuiltin command1 = context.getShellContext().builtins().find(commandName);
                    if (command1 == null) {
                        context.err().printf("command not found : %s\n", new Object[]{text.ofStyled(commandName, NutsTextStyle.error())});
                        x3 = 1;
                        continue;
                    }
                    String help = command1.getHelp();
                    context.out().printf("%s : %s\f", new Object[]{text.ofStyled("COMMAND", NutsTextStyle.primary4()), "commandName"});
                    context.out().println((String)ss.apply(help));
                }
                this.throwExecutionException("error", x3, context.getSession());
            }
        }
    }

    private static class Options {
        boolean code = false;
        List<String> commandNames = new ArrayList<String>();

        private Options() {
        }
    }
}

