/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class HeadCommand
extends SimpleJShellBuiltin {
    public HeadCommand() {
        super("head", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isOption() && a.getKey().isInt()) {
            options.max = a.getKey().getInt();
            commandLine.skip();
            return true;
        }
        if (!a.isOption()) {
            String path = commandLine.next().getString();
            String file = NutsPath.of((String)path, (NutsSession)context.getSession()).toAbsolute(context.getShellContext().getCwd()).toString();
            options.files.add(file);
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.isEmpty()) {
            commandLine.required();
        }
        for (String file : options.files) {
            this.head(file, options.max, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void head(String file, int max, JShellExecutionContext context) {
        BufferedReader r = null;
        NutsSession session = context.getSession();
        try {
            try {
                r = new BufferedReader(new InputStreamReader(NutsPath.of((String)file, (NutsSession)session).getInputStream()));
                String line = null;
                for (int count = 0; count < max && (line = r.readLine()) != null; ++count) {
                    session.out().println(line);
                }
            }
            finally {
                if (r != null) {
                    r.close();
                }
            }
        }
        catch (IOException ex) {
            throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    private static class Options {
        int max = 0;
        List<String> files = new ArrayList<String>();

        private Options() {
        }
    }
}

