/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsExecutionType;
import net.thevpc.nuts.NutsRunAs;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class EnvCommand
extends SimpleJShellBuiltin {
    public EnvCommand() {
        super("env", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        switch (options.readStatus) {
            case 0: {
                switch (a.getKey().getString()) {
                    case "--sort": {
                        options.sort = commandLine.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "--external": 
                    case "--spawn": 
                    case "-x": {
                        commandLine.skip();
                        options.executionType = NutsExecutionType.SPAWN;
                        return true;
                    }
                    case "--embedded": 
                    case "-b": {
                        commandLine.skip();
                        options.executionType = NutsExecutionType.EMBEDDED;
                        return true;
                    }
                    case "--system": {
                        commandLine.skip();
                        options.executionType = NutsExecutionType.SYSTEM;
                        return true;
                    }
                    case "--current-user": {
                        commandLine.skip();
                        options.runAs = NutsRunAs.currentUser();
                        return true;
                    }
                    case "--as-root": {
                        commandLine.skip();
                        options.runAs = NutsRunAs.root();
                        return true;
                    }
                    case "--sudo": {
                        commandLine.skip();
                        options.runAs = NutsRunAs.sudo();
                        return true;
                    }
                    case "--as-user": {
                        a = commandLine.nextString(new String[0]);
                        options.runAs = NutsRunAs.user((String)a.getValue().getString());
                        return true;
                    }
                    case "-C": 
                    case "--chdir": {
                        options.dir = commandLine.nextString(new String[0]).getValue().getString();
                        return true;
                    }
                    case "-u": 
                    case "--unset": {
                        options.unsetVers.add(commandLine.nextString(new String[0]).getValue().getString());
                        return true;
                    }
                    case "-i": 
                    case "--ignore-environment": {
                        options.ignoreEnvironment = commandLine.nextBoolean(new String[0]).getBooleanValue();
                        return true;
                    }
                    case "-": {
                        commandLine.skip();
                        options.readStatus = 1;
                        return true;
                    }
                }
                if (a.isKeyValue()) {
                    options.newEnv.put(a.getKey().getString(), a.getValue().getString());
                    commandLine.skip();
                    options.readStatus = 1;
                    return true;
                }
                if (a.isOption()) {
                    return false;
                }
                options.command.add(a.getString());
                commandLine.skip();
                options.readStatus = 2;
                return true;
            }
            case 1: {
                if (a.isKeyValue()) {
                    options.newEnv.put(a.getKey().getString(), a.getValue().getString());
                } else {
                    options.command.add(a.getString());
                    options.readStatus = 2;
                }
                commandLine.skip();
                return true;
            }
            case 2: {
                options.command.add(a.getString());
                commandLine.skip();
                return true;
            }
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.sort) {
            context.getSession().addOutputFormatOptions(new String[]{"--sort"});
        }
        TreeMap<Object, Object> env = new TreeMap<Object, Object>();
        if (!options.ignoreEnvironment) {
            env.putAll(context.getShellContext().vars().getAll());
        }
        for (String v : options.unsetVers) {
            env.remove(v);
        }
        env.putAll(options.newEnv);
        if (options.command.isEmpty()) {
            context.getSession().out().printlnf(env);
        } else {
            NutsExecCommand e = context.getSession().exec().addCommand(options.command).setEnv(env).setFailFast(true);
            if (options.dir != null) {
                e.setDirectory(options.dir);
            }
            if (options.executionType != null) {
                e.setExecutionType(options.executionType);
            }
            e.run();
        }
    }

    public static class Options {
        int readStatus = 0;
        LinkedHashMap<String, String> newEnv = new LinkedHashMap();
        List<String> command = new ArrayList<String>();
        Set<String> unsetVers = new HashSet<String>();
        boolean sort = true;
        boolean ignoreEnvironment = false;
        String dir = null;
        NutsExecutionType executionType = null;
        NutsRunAs runAs = null;
    }
}

