/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class EnableCommand
extends SimpleJShellBuiltin {
    public EnableCommand() {
        super("enable", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isOption()) {
            if (a.getKey().getString().equals("--sort")) {
                options.displayOptions.add(a.toString());
                return true;
            }
        } else if (a.isOption()) {
            switch (a.getKey().getString()) {
                case "-a": {
                    options.a = commandLine.nextBoolean(new String[0]).getBooleanValue();
                    return true;
                }
                case "-d": {
                    options.d = commandLine.nextBoolean(new String[0]).getBooleanValue();
                    return true;
                }
                case "-n": {
                    options.n = commandLine.nextBoolean(new String[0]).getBooleanValue();
                    return true;
                }
                case "-p": {
                    options.p = commandLine.nextBoolean(new String[0]).getBooleanValue();
                    return true;
                }
                case "-s": {
                    options.s = commandLine.nextBoolean(new String[0]).getBooleanValue();
                    return true;
                }
                case "-f": {
                    options.file = commandLine.nextString(new String[0]).getValue().getString();
                    return true;
                }
            }
        } else {
            options.names.add(commandLine.next().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        block10: {
            Options options;
            block9: {
                options = (Options)context.getOptions();
                if (!options.p && !options.names.isEmpty()) break block9;
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (JShellBuiltin command : context.getShellContext().builtins().getAll()) {
                    result.put(command.getName(), command.isEnabled() ? "enabled" : "disabled");
                }
                switch (context.getSession().getOutputFormat()) {
                    case PLAIN: {
                        for (Map.Entry entry : result.entrySet()) {
                            context.getSession().out().println((String)entry.getValue() + " " + (String)entry.getKey());
                        }
                        break block10;
                    }
                    default: {
                        context.getSession().out().printlnf(result);
                    }
                }
                break block10;
            }
            if (options.n) {
                ArrayList<String> nobuiltin = new ArrayList<String>();
                for (String string : options.names) {
                    JShellBuiltin c = context.getShellContext().builtins().find(string);
                    if (c == null) {
                        nobuiltin.add(string);
                        continue;
                    }
                    c.setEnabled(false);
                }
                if (!nobuiltin.isEmpty()) {
                    this.throwExecutionException(nobuiltin, 1, context.getSession());
                }
            }
        }
    }

    private static class Options {
        String file;
        boolean a;
        boolean d;
        boolean n;
        boolean p;
        boolean s;
        Set<String> names = new LinkedHashSet<String>();
        List<String> displayOptions = new ArrayList<String>();

        private Options() {
        }
    }
}

