/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class EchoCommand
extends SimpleJShellBuiltin {
    public EchoCommand() {
        super("echo", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        switch (commandLine.peek().getKey().getString()) {
            case "-n": {
                options.newLine = !commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
            case "-p": 
            case "--plain": {
                options.highlighter = null;
                return true;
            }
            case "-H": 
            case "--highlight": 
            case "--highlighter": {
                options.highlighter = NutsUtilStrings.trim((String)commandLine.next().getValue().getString());
                return true;
            }
        }
        if (commandLine.peek().isNonOption()) {
            while (commandLine.hasNext()) {
                if (options.tokensCount > 0) {
                    options.message.append(" ");
                }
                options.message.append(commandLine.next().toString());
                ++options.tokensCount;
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        String ns = null;
        if (options.highlighter == null) {
            ns = options.message.toString();
        } else {
            NutsTextCode c = NutsTexts.of((NutsSession)context.getSession()).ofCode(options.highlighter.isEmpty() ? "ntf" : options.highlighter, options.message.toString());
            ns = c.highlight(context.getSession());
        }
        if (options.newLine) {
            context.getSession().out().printlnf((Object)ns);
        } else {
            context.getSession().out().printf((Object)ns);
        }
    }

    private static class Options {
        boolean newLine = true;
        String highlighter = null;
        boolean first = true;
        StringBuilder message = new StringBuilder();
        int tokensCount = 0;

        private Options() {
        }
    }
}

