/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class CommandCommand
extends SimpleJShellBuiltin {
    public CommandCommand() {
        super("command", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = null;
        if (context.configureFirst(commandLine)) {
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-p"});
        if (a != null) {
            options.p = a.getBooleanValue();
        } else if (!commandLine.peek().isOption()) {
            if (options.commandName == null) {
                options.commandName = commandLine.next().getString();
            }
            options.args.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.commandName != null) {
            context.getShell().executePreparedCommand(options.args.toArray(new String[0]), false, true, true, context.getShellContext());
        }
    }

    private static class Options {
        boolean p;
        String commandName;
        List<String> args;

        private Options() {
        }
    }
}

