/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathPermission;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class ChmodCommand
extends SimpleJShellBuiltin {
    public ChmodCommand() {
        super("chmod", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (context.configureFirst(commandLine)) {
            return true;
        }
        NutsArgument a = commandLine.peek();
        String s = a.getString();
        if (s.equals("-R") || s.equals("--recursive")) {
            commandLine.skip();
            options.m.recursive = true;
            return true;
        }
        commandLine.skip();
        boolean add = true;
        boolean x = false;
        boolean w = false;
        boolean r = false;
        boolean user = false;
        boolean group = false;
        boolean others = false;
        block11: for (char c : s.substring(1).toCharArray()) {
            switch (c) {
                case '+': {
                    add = true;
                    continue block11;
                }
                case '-': {
                    add = false;
                    continue block11;
                }
                case 'a': {
                    user = true;
                    group = true;
                    others = true;
                    continue block11;
                }
                case 'u': {
                    user = true;
                    continue block11;
                }
                case 'g': {
                    group = true;
                    continue block11;
                }
                case 'o': {
                    others = true;
                    continue block11;
                }
                case 'r': {
                    if (user || !group && !others) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.CAN_READ);
                            options.m.addPermissions.add(NutsPathPermission.OWNER_READ);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.CAN_READ);
                            options.m.removePermissions.add(NutsPathPermission.OWNER_READ);
                        }
                    }
                    if (group) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.GROUP_READ);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.GROUP_READ);
                        }
                    }
                    if (!others) continue block11;
                    if (add) {
                        options.m.addPermissions.add(NutsPathPermission.OTHERS_READ);
                        continue block11;
                    }
                    options.m.removePermissions.add(NutsPathPermission.OTHERS_READ);
                    continue block11;
                }
                case 'w': {
                    if (user || !group && !others) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.CAN_WRITE);
                            options.m.addPermissions.add(NutsPathPermission.OWNER_WRITE);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.CAN_WRITE);
                            options.m.removePermissions.add(NutsPathPermission.OWNER_WRITE);
                        }
                    }
                    if (group) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.GROUP_WRITE);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.GROUP_WRITE);
                        }
                    }
                    if (!others) continue block11;
                    if (add) {
                        options.m.addPermissions.add(NutsPathPermission.OTHERS_WRITE);
                        continue block11;
                    }
                    options.m.removePermissions.add(NutsPathPermission.OTHERS_WRITE);
                    continue block11;
                }
                case 'x': {
                    if (user || !group && !others) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.CAN_EXECUTE);
                            options.m.addPermissions.add(NutsPathPermission.OWNER_EXECUTE);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.CAN_EXECUTE);
                            options.m.removePermissions.add(NutsPathPermission.OWNER_EXECUTE);
                        }
                    }
                    if (group) {
                        if (add) {
                            options.m.addPermissions.add(NutsPathPermission.GROUP_EXECUTE);
                        } else {
                            options.m.removePermissions.add(NutsPathPermission.GROUP_EXECUTE);
                        }
                    }
                    if (!others) continue block11;
                    if (add) {
                        options.m.addPermissions.add(NutsPathPermission.OTHERS_EXECUTE);
                        continue block11;
                    }
                    options.m.removePermissions.add(NutsPathPermission.OTHERS_EXECUTE);
                    continue block11;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.isEmpty()) {
            commandLine.required();
        }
        LinkedHashMap<NutsPath, NutsMessage> errors = new LinkedHashMap<NutsPath, NutsMessage>();
        for (NutsPath f : options.files) {
            this.chmod(f, options.m, errors);
        }
        if (!errors.isEmpty()) {
            this.throwExecutionException(errors, 1, context.getSession());
        }
    }

    private void chmod(NutsPath f, Mods m, Map<NutsPath, NutsMessage> errors) {
        f.addPermissions(m.addPermissions.toArray(new NutsPathPermission[0]));
        f.removePermissions(m.removePermissions.toArray(new NutsPathPermission[0]));
        if (f.isDirectory()) {
            for (NutsPath file : f.list()) {
                this.chmod(file, m, errors);
            }
        }
    }

    private static class Options {
        List<NutsPath> files = new ArrayList<NutsPath>();
        Mods m = new Mods();

        private Options() {
        }
    }

    private static class Mods {
        Set<NutsPathPermission> addPermissions = new HashSet<NutsPathPermission>();
        Set<NutsPathPermission> removePermissions = new HashSet<NutsPathPermission>();
        boolean recursive = false;

        private Mods() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (NutsPathPermission p : this.addPermissions) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("+").append(p.id());
            }
            for (NutsPathPermission p : this.removePermissions) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append("-").append(p.id());
            }
            if (this.recursive) {
                sb.append(",recursive");
            }
            return sb.toString();
        }
    }
}

