/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsContentType;
import net.thevpc.nuts.NutsCp;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsText;
import net.thevpc.nuts.NutsTextBuilder;
import net.thevpc.nuts.NutsTextCode;
import net.thevpc.nuts.NutsTextPlain;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTextStyled;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.bundles._IOUtils;
import net.thevpc.nuts.toolbox.nsh.bundles._StringUtils;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.util.ColumnRuler;
import net.thevpc.nuts.toolbox.nsh.util.FileInfo;
import net.thevpc.nuts.toolbox.nsh.util.ShellHelper;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class CatCommand
extends SimpleJShellBuiltin {
    public CatCommand() {
        super("cat", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (commandLine.next(new String[]{"-"}) != null) {
            options.files.add(null);
            return true;
        }
        NutsArgument a = commandLine.nextBoolean(new String[]{"-n", "--number"});
        if (a != null) {
            options.n = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-t", "--show-tabs"});
        if (a != null) {
            options.T = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextBoolean(new String[]{"-E", "--show-ends"});
        if (a != null) {
            options.E = a.getBooleanValue();
            return true;
        }
        a = commandLine.next(new String[]{"-H", "--highlight", "--highlighter"});
        if (a != null) {
            options.highlighter = NutsUtilStrings.trim((String)a.getValue().getString());
            return true;
        }
        if (!commandLine.peek().isOption()) {
            String path = commandLine.next().getString();
            options.files.add(new FileInfo(NutsPath.of((String)path, (NutsSession)context.getSession()), options.highlighter));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.isEmpty()) {
            options.files.add(null);
        }
        NutsPrintStream out = context.getSession().out();
        try {
            options.currentNumber = 1L;
            OutputStream os = null;
            boolean plain = true;
            if (context.getSession().getOutputFormat() == NutsContentType.PLAIN) {
                os = out.asOutputStream();
            } else {
                plain = false;
            }
            ArrayList<CatResult> results = new ArrayList<CatResult>();
            for (FileInfo f : options.files) {
                boolean close = false;
                InputStream in = null;
                if (f.getFile() == null) {
                    in = context.in();
                    if (f.getHighlighter() == null) {
                        f.setHighlighter("plain");
                    } else if (f.getHighlighter().isEmpty()) {
                        f.setHighlighter("ntf");
                    }
                } else {
                    in = f.getFile().getInputStream();
                    if (f.getHighlighter() == null) {
                        f.setHighlighter("plain");
                    } else if (f.getHighlighter().isEmpty()) {
                        f.setHighlighter(f.getFile().getContentType());
                        if (f.getHighlighter() == null) {
                            f.setHighlighter("plain");
                        }
                    }
                    close = true;
                }
                try {
                    if (plain) {
                        this.catText(in, os, options, context, f);
                        continue;
                    }
                    this.catText2(in, options, context, f, results);
                }
                finally {
                    if (!close) continue;
                    in.close();
                }
            }
            if (!plain) {
                out.printf(results);
            }
        }
        catch (IOException ex) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    private void catText2(InputStream in, Options options, JShellExecutionContext context, FileInfo info, List<CatResult> results) throws IOException {
        boolean whole = true;
        NutsSession session = context.getSession();
        if (whole && info.getHighlighter() != null) {
            NutsText line;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            NutsCp.of((NutsSession)session).from(in).to((OutputStream)bout).run();
            String text = bout.toString();
            NutsTextBuilder nutsText = NutsTexts.of((NutsSession)session).ofCode(info.getHighlighter(), text).highlight(session).builder().flatten();
            List children = nutsText.getChildren();
            Tracker tracker = new Tracker();
            boolean n = options.n;
            options.n = false;
            while ((line = this.nextLine(children, session, tracker, options, true)) != null) {
                CatResult r = new CatResult();
                if (n) {
                    r.number = tracker.line;
                }
                r.line = line;
                results.add(r);
            }
            options.n = n;
        } else {
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                CatResult r = new CatResult();
                if (options.n) {
                    r.number = options.currentNumber;
                }
                if (options.T) {
                    line = line.replace("\t", "^I");
                }
                NutsTextCode c = NutsTexts.of((NutsSession)session).ofCode(info.getHighlighter(), line);
                line = c.highlight(session).toString();
                if (options.E) {
                    line = line + "$";
                }
                r.line = NutsTexts.of((NutsSession)session).ofPlain(line);
                ++options.currentNumber;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void catText(InputStream in, OutputStream os, Options options, JShellExecutionContext context, FileInfo info) throws IOException {
        if (!(info.getHighlighter() != null || options.n || options.T || options.E)) {
            _IOUtils.copy(in, os, 8192);
            return;
        }
        boolean whole = true;
        NutsSession session = context.getSession();
        if (whole && info.getHighlighter() != null) {
            NutsText line;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            NutsCp.of((NutsSession)session).from(in).to((OutputStream)bout).run();
            String text = bout.toString();
            NutsTextBuilder nutsText = NutsTexts.of((NutsSession)session).ofCode(info.getHighlighter(), text).highlight(session).builder().flatten();
            NutsPrintStream out = NutsPrintStream.of((OutputStream)os, (NutsSession)session);
            List children = nutsText.getChildren();
            Tracker tracker = new Tracker();
            while ((line = this.nextLine(children, session, tracker, options, false)) != null) {
                out.printf((Object)line);
            }
        } else {
            NutsPrintStream out = NutsPrintStream.of((OutputStream)os, (NutsSession)session);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (options.n) {
                        out.print(_StringUtils.formatRight(String.valueOf(options.currentNumber), 6));
                        out.print("  ");
                    }
                    if (options.T) {
                        line = line.replace("\t", "^I");
                    }
                    NutsTextCode c = NutsTexts.of((NutsSession)session).ofCode(info.getHighlighter(), line);
                    line = c.highlight(session).toString();
                    out.print(line);
                    if (options.E) {
                        out.println("$");
                    }
                    out.println();
                    ++options.currentNumber;
                }
            }
            finally {
                out.flush();
            }
        }
    }

    private NutsText nextLine(List<NutsText> t, NutsSession session, Tracker tracker, Options options, boolean skipNewline) {
        NutsTextBuilder b = NutsTexts.of((NutsSession)session).builder();
        while (!t.isEmpty()) {
            NutsText ii = t.remove(0);
            NutsText n = this.nextNode(ii, session, tracker, options);
            if (tracker.wasNewline) {
                if (!skipNewline) {
                    b.append(n);
                }
                return b.build();
            }
            b.append(n);
        }
        return null;
    }

    private NutsText nextNode(NutsText t, NutsSession session, Tracker tracker, Options options) {
        switch (t.getType()) {
            case PLAIN: {
                String text = ((NutsTextPlain)t).getText();
                NutsTextBuilder tb = NutsTexts.of((NutsSession)session).builder();
                if (options.n && tracker.wasNewline) {
                    tb.append((Object)tracker.ruler.nextNum(tracker.line, session));
                }
                if (text.charAt(0) == '\n' || text.charAt(0) == '\r') {
                    if (options.E) {
                        tb.append((Object)"$", NutsTextStyle.separator());
                    }
                    tb.append((Object)text);
                    tracker.wasNewline = true;
                    ++tracker.line;
                } else {
                    for (String s : ShellHelper.splitOn(text, '\t')) {
                        if (s.startsWith("\t")) {
                            tb.append((Object)"^I", NutsTextStyle.separator());
                            continue;
                        }
                        tb.append((Object)s);
                    }
                    tracker.wasNewline = false;
                }
                return tb.build();
            }
            case STYLED: {
                NutsTextStyled tt = (NutsTextStyled)t;
                NutsTextPlain pt = (NutsTextPlain)tt.getChild();
                String text = pt.getText();
                NutsTextBuilder tb = NutsTexts.of((NutsSession)session).builder();
                if (options.n && tracker.wasNewline) {
                    tb.append((Object)tracker.ruler.nextNum(tracker.line, session));
                }
                for (String s : ShellHelper.splitOn(text, '\t')) {
                    if (s.startsWith("\t")) {
                        tb.append((Object)"^I", NutsTextStyle.separator());
                        continue;
                    }
                    tb.append((Object)s, tt.getStyles());
                }
                tracker.wasNewline = false;
                return tb.build();
            }
        }
        throw new NutsIllegalArgumentException(session, NutsMessage.cstyle((String)"unsupported", (Object[])new Object[0]));
    }

    private class Tracker {
        ColumnRuler ruler = new ColumnRuler(6);
        long line;
        boolean wasNewline = true;

        private Tracker() {
        }
    }

    private static class Options {
        String highlighter = null;
        boolean n = false;
        boolean T = false;
        boolean E = false;
        List<FileInfo> files = new ArrayList<FileInfo>();
        long currentNumber;

        private Options() {
        }
    }

    public static class CatResult {
        Long number;
        NutsString line;
    }
}

