/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class BaseNameCommand
extends SimpleJShellBuiltin {
    public BaseNameCommand() {
        super("basename", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine cmdLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = cmdLine.peek();
        switch (a.getKey().getString()) {
            case "-z": 
            case "--zero": {
                cmdLine.skip();
                options.sep = "\u0000";
                return true;
            }
            case "-a": 
            case "--all": 
            case "--multi": {
                options.multi = cmdLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
            case "-s": 
            case "--suffix": {
                options.suffix = cmdLine.nextString(new String[0]).getValue().getString();
                options.multi = true;
                return true;
            }
        }
        if (!a.isOption()) {
            while (!cmdLine.isEmpty()) {
                NutsArgument n = cmdLine.nextNonOption();
                if (options.names.isEmpty()) {
                    options.names.add(n.toString());
                    continue;
                }
                if (options.multi) {
                    options.names.add(n.toString());
                    continue;
                }
                if (options.names.size() == 1 && options.suffix == null) {
                    options.suffix = n.toString();
                    continue;
                }
                cmdLine.pushBack(n);
                cmdLine.unexpectedArgument();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.names.isEmpty()) {
            commandLine.required();
        }
        ArrayList<String> results = new ArrayList<String>();
        for (String name : options.names) {
            String basename;
            StringBuilder sb = new StringBuilder(name);
            int lastNameLen = 0;
            while (sb.length() - lastNameLen > 0 && sb.charAt(sb.length() - 1 - lastNameLen) != '/') {
                ++lastNameLen;
            }
            if (lastNameLen == 0) {
                while (sb.length() > 1 && sb.charAt(sb.length() - 1) == '/') {
                    sb.deleteCharAt(sb.length() - 1);
                }
                while (sb.length() - lastNameLen > 0 && sb.charAt(sb.length() - 1 - lastNameLen) != '/') {
                    ++lastNameLen;
                }
            }
            String string = basename = lastNameLen == 0 ? sb.toString() : sb.substring(sb.length() - lastNameLen);
            if (options.suffix != null && basename.endsWith(options.suffix)) {
                basename = basename.substring(0, basename.length() - options.suffix.length());
            }
            results.add(basename);
        }
        switch (context.getSession().getOutputFormat()) {
            case PLAIN: {
                for (int i = 0; i < results.size(); ++i) {
                    String name;
                    name = (String)results.get(i);
                    if (i > 0) {
                        context.getSession().out().print(options.sep);
                    }
                    context.getSession().out().print(name);
                }
                break;
            }
            default: {
                context.getSession().out().printlnf(results);
            }
        }
    }

    private static class Options {
        String sep = "\n";
        List<String> names = new ArrayList<String>();
        boolean multi = false;
        String suffix = null;

        private Options() {
        }
    }
}

