/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.bundles;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;

public class _IOUtils {
    public static final int DEFAULT_BUFFER_SIZE = 1024;

    public static String loadString(URL url) throws IOException {
        return new String(_IOUtils.loadByteArray(url));
    }

    public static String loadString(InputStream r) throws IOException {
        return new String(_IOUtils.loadByteArray(r));
    }

    public static byte[] loadByteArray(URL url) throws IOException {
        try (InputStream r = null;){
            r = url.openStream();
            byte[] byArray = _IOUtils.loadByteArray(r);
            return byArray;
        }
    }

    public static byte[] loadByteArray(InputStream r) throws IOException {
        try (ByteArrayOutputStream out = null;){
            out = new ByteArrayOutputStream();
            _IOUtils.copy(r, (OutputStream)out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        int len;
        byte[] buffer = new byte[bufferSize];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }

    public static void copy(NutsPath in, OutputStream out) throws IOException {
        _IOUtils.copy(in, out, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(NutsPath in, OutputStream out, int bufferSize) throws IOException {
        try (InputStream fis = null;){
            fis = in.getInputStream();
            _IOUtils.copy(fis, out, bufferSize);
        }
    }

    public static String getAbsoluteFile2(String path, String cwd, NutsSession session) {
        NutsPath np = NutsPath.of((String)path, (NutsSession)session);
        if (np.isAbsolute()) {
            return path;
        }
        if (cwd == null) {
            cwd = System.getProperty("user.dir");
        }
        switch (path) {
            case "~": {
                return System.getProperty("user.home");
            }
        }
        if (path.startsWith("~/") || path.startsWith("~\\")) {
            return NutsPath.ofUserHome((NutsSession)session).resolve(path.substring(2)).normalize().toAbsolute().toString();
        }
        return np.toAbsolute(cwd).normalize().toAbsolute().toString();
    }
}

