/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.bundles;

import net.thevpc.nuts.toolbox.nsh.bundles.DoubleFormat;
import net.thevpc.nuts.toolbox.nsh.bundles._StringUtils;

public class BytesSizeFormat
implements DoubleFormat {
    public static final BytesSizeFormat INSTANCE = new BytesSizeFormat();
    boolean leadingZeros = false;
    boolean intermediateZeros = true;
    boolean trailingZeros = false;
    boolean alignRight = false;
    private boolean fixedLength = false;
    private boolean binaryPrefix = false;
    private boolean standardUnit = false;
    private int high = 12;
    private int low = 1;
    private int depth = Integer.MAX_VALUE;

    public BytesSizeFormat(boolean leadingZeros, boolean intermediateZeros, boolean fixedLength, boolean binaryPrefix, char high, char low, int depth) {
        this.leadingZeros = leadingZeros;
        this.intermediateZeros = intermediateZeros;
        this.fixedLength = fixedLength;
        this.binaryPrefix = binaryPrefix;
        this.high = this.evalIndex(high);
        this.low = this.evalIndex(low);
        this.depth = depth <= 0 ? Integer.MAX_VALUE : depth;
    }

    public BytesSizeFormat() {
        this("B0EF");
    }

    @Override
    public String formatDouble(double value) {
        return this.format((long)value);
    }

    public BytesSizeFormat(String format) {
        this.leadingZeros = false;
        this.intermediateZeros = false;
        this.trailingZeros = false;
        this.alignRight = true;
        if (format != null) {
            boolean startInterval = true;
            char[] charArray = format.toCharArray();
            block10: for (int i = 0; i < charArray.length; ++i) {
                char c = charArray[i];
                switch (c) {
                    case 'B': 
                    case 'E': 
                    case 'G': 
                    case 'K': 
                    case 'M': 
                    case 'P': 
                    case 'T': 
                    case 'Y': 
                    case 'Z': {
                        if (startInterval) {
                            startInterval = false;
                            this.low = this.evalIndex(c);
                            continue block10;
                        }
                        this.high = this.evalIndex(c);
                        continue block10;
                    }
                    case 'I': {
                        this.binaryPrefix = true;
                        this.standardUnit = false;
                        continue block10;
                    }
                    case 'i': {
                        this.binaryPrefix = true;
                        this.standardUnit = true;
                        continue block10;
                    }
                    case 'D': {
                        this.depth = Character.isDigit(charArray[++i]) ? charArray[i] - 48 : -1;
                        if (this.depth <= 0 || this.depth > 9) {
                            throw new IllegalArgumentException("Invalid depth " + this.depth);
                        }
                    }
                    case 'F': {
                        this.fixedLength = true;
                        continue block10;
                    }
                    case '>': {
                        this.fixedLength = true;
                        this.alignRight = true;
                        continue block10;
                    }
                    case '<': {
                        this.fixedLength = true;
                        this.alignRight = false;
                        continue block10;
                    }
                    case '0': {
                        if (i == 0) {
                            this.leadingZeros = true;
                            continue block10;
                        }
                        if (i == charArray.length - 1) {
                            this.trailingZeros = true;
                            continue block10;
                        }
                        this.intermediateZeros = true;
                        continue block10;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported " + c);
                    }
                }
            }
        }
        if (this.high < this.low) {
            int t = this.low;
            this.low = this.high;
            this.high = t;
        }
    }

    private char evalCharByIndex(int c) {
        switch (c) {
            case 1: {
                return 'B';
            }
            case 2: {
                return 'K';
            }
            case 6: {
                return 'M';
            }
            case 9: {
                return 'G';
            }
            case 12: {
                return 'T';
            }
            case 15: {
                return 'P';
            }
            case 18: {
                return 'E';
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private int evalIndex(char c) {
        switch (c) {
            case 'B': {
                return 1;
            }
            case 'K': {
                return 3;
            }
            case 'M': {
                return 6;
            }
            case 'G': {
                return 9;
            }
            case 'T': {
                return 12;
            }
            case 'P': {
                return 15;
            }
            case 'E': {
                return 18;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private long eval(char c) {
        switch (c) {
            case 'B': {
                return this.binaryPrefix ? 1L : 1L;
            }
            case 'K': {
                return this.binaryPrefix ? 1024L : 1000L;
            }
            case 'M': {
                return this.binaryPrefix ? 0x100000L : 1000000L;
            }
            case 'G': {
                return this.binaryPrefix ? 0x40000000L : 1000000000L;
            }
            case 'T': {
                return this.binaryPrefix ? 0x10000000000L : 1000000000000L;
            }
            case 'P': {
                return this.binaryPrefix ? 0x4000000000000L : 1000000000000000L;
            }
            case 'E': {
                return this.binaryPrefix ? 0x1000000000000000L : 1000000000000000000L;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private long evalLongByIndex(int c) {
        switch (c) {
            case 1: {
                return this.binaryPrefix ? 1L : 1L;
            }
            case 3: {
                return this.binaryPrefix ? 1024L : 1000L;
            }
            case 6: {
                return this.binaryPrefix ? 0x100000L : 1000000L;
            }
            case 9: {
                return this.binaryPrefix ? 0x40000000L : 1000000000L;
            }
            case 12: {
                return this.binaryPrefix ? 0x10000000000L : 1000000000000L;
            }
            case 15: {
                return this.binaryPrefix ? 0x4000000000000L : 1000000000000000L;
            }
            case 18: {
                return this.binaryPrefix ? 0x1000000000000000L : 1000000000000000000L;
            }
        }
        throw new IllegalArgumentException("Unsupported");
    }

    private String formatNumber(Object number, int size) {
        if (this.fixedLength) {
            if (this.alignRight) {
                return _StringUtils.formatRight(number, size);
            }
            return _StringUtils.formatLeft(number, size);
        }
        return String.valueOf(number);
    }

    public String format(long bytes) {
        long v;
        StringBuilder sb = new StringBuilder();
        boolean neg = bytes < 0L;
        long r = v = bytes < 0L ? -bytes : bytes;
        int currDepth = -1;
        boolean empty = true;
        boolean leading = true;
        long K = this.eval('K');
        long M = this.eval('M');
        long G = this.eval('G');
        long T = this.eval('T');
        long P = this.eval('P');
        long E = this.eval('E');
        int KK = 3;
        int MM = 6;
        int GG = 9;
        int TT = 12;
        int PP = 15;
        int EE = 18;
        if (this.low <= EE) {
            if (this.high >= EE) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % E > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Ei" : "E");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= E;
                        empty = false;
                    }
                }
            }
            if (this.high >= PP) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % P > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Pi" : "P");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= P;
                        empty = false;
                    }
                }
            }
            if (this.high >= TT) {
                r = v / T;
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % T > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Ti" : "T");
                        if (r != 0L) {
                            leading = false;
                        }
                        v %= T;
                        empty = false;
                    }
                }
            }
            if (this.low <= GG) {
                if (this.high >= GG) {
                    r = v / G;
                }
                if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % G > 0L || v == 0L && this.trailingZeros) {
                    currDepth = currDepth < 0 ? 1 : ++currDepth;
                    if (currDepth <= this.depth) {
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        if (r != 0L) {
                            leading = false;
                        }
                        sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Gi" : "G");
                        v %= G;
                        empty = false;
                    }
                }
                if (this.low <= MM) {
                    if (this.high >= MM) {
                        r = v / M;
                        if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % M > 0L || v == 0L && this.trailingZeros) {
                            currDepth = currDepth < 0 ? 1 : ++currDepth;
                            if (currDepth <= this.depth) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                if (r != 0L) {
                                    leading = false;
                                }
                                sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Mi" : "M");
                                v %= M;
                                empty = false;
                            }
                        }
                    }
                    if (this.low <= KK) {
                        if (this.high >= KK) {
                            r = v / K;
                            if (this.leadingZeros && leading || r > 0L || !empty && this.intermediateZeros && v % K > 0L || v == 0L && this.trailingZeros) {
                                currDepth = currDepth < 0 ? 1 : ++currDepth;
                                if (currDepth <= this.depth) {
                                    if (sb.length() > 0) {
                                        sb.append(" ");
                                    }
                                    if (r != 0L) {
                                        leading = false;
                                    }
                                    sb.append(this.formatNumber(r, 3)).append(this.binaryPrefix && !this.standardUnit ? "Ki" : "K");
                                    v %= K;
                                    empty = false;
                                }
                            }
                        }
                        if (this.low <= 1 && (this.leadingZeros && leading || v > 0L || sb.length() == 0)) {
                            currDepth = currDepth < 0 ? 1 : ++currDepth;
                            if (currDepth <= this.depth) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                if (r != 0L) {
                                    leading = false;
                                }
                                sb.append(this.formatNumber(v, 3)).append(this.binaryPrefix && !this.standardUnit ? "B " : "B");
                                empty = false;
                            }
                        }
                    }
                }
            }
        }
        if (sb.length() == 0) {
            if (neg) {
                sb.insert(0, "-");
            }
            if ((long)this.low >= T) {
                sb.append(this.formatNumber(0, 3)).append(this.binaryPrefix && !this.standardUnit ? "Ti" : "T");
            } else if ((long)this.low >= G) {
                sb.append(this.formatNumber(0, 3)).append(this.binaryPrefix && !this.standardUnit ? "Gi" : "G");
            } else if ((long)this.low >= M) {
                sb.append(this.formatNumber(0, 3)).append(this.binaryPrefix && !this.standardUnit ? "Mi" : "M");
            } else if ((long)this.low >= K) {
                sb.append(this.formatNumber(0, 3)).append(this.binaryPrefix && !this.standardUnit ? "Ki" : "K");
                sb.append(this.formatNumber(0, 3)).append(this.binaryPrefix && !this.standardUnit ? "B " : "B");
            }
        } else if (neg) {
            sb.insert(0, "-");
        }
        return sb.toString();
    }

    public String toPattern() {
        StringBuilder sb = new StringBuilder();
        if (this.leadingZeros) {
            sb.append('0');
        }
        sb.append(' ').append(this.evalCharByIndex(this.low));
        sb.append(' ').append(this.evalCharByIndex(this.high));
        if (this.depth >= 0) {
            sb.append('D').append(this.depth);
        }
        if (this.standardUnit) {
            sb.append('i');
        }
        if (this.binaryPrefix) {
            sb.append('I');
        }
        if (this.fixedLength) {
            sb.append('F');
        }
        if (this.intermediateZeros) {
            sb.append(' ');
            sb.append('0');
        }
        if (this.alignRight) {
            sb.append('>');
        } else {
            sb.append('<');
        }
        if (this.trailingZeros) {
            sb.append('0');
        }
        return sb.toString();
    }
}

