/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.toolbox.nsh.AbstractJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

public abstract class SimpleJShellBuiltin
extends AbstractJShellBuiltin {
    private Class optionsClass;

    public SimpleJShellBuiltin(String name, int supportLevel, Class optionsClass) {
        super(name, supportLevel);
        this.optionsClass = optionsClass;
    }

    protected Object createOptions() {
        if (this.optionsClass == null) {
            return null;
        }
        try {
            Constructor c = this.optionsClass.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected abstract boolean configureFirst(NutsCommandLine var1, JShellExecutionContext var2);

    protected abstract void execBuiltin(NutsCommandLine var1, JShellExecutionContext var2);

    @Override
    public void execImpl(String[] args, JShellExecutionContext context) {
        boolean conf = false;
        int maxLoops = 1000;
        boolean robustMode = false;
        NutsSession session = context.getSession();
        NutsCommandLine commandLine = NutsCommandLine.of((String[])args, (NutsSession)session).setCommandName(this.getName()).setAutoComplete(context.getShellContext().getAutoComplete());
        this.initCommandLine(commandLine);
        context.setOptions(this.createOptions());
        while (commandLine.hasNext()) {
            if (robustMode) {
                Object[] before = commandLine.toStringArray();
                if (!this.configureFirst(commandLine, context)) {
                    context.configureLast(commandLine);
                } else {
                    conf = true;
                }
                Object[] after = commandLine.toStringArray();
                if (Arrays.equals(before, after)) {
                    throw new IllegalStateException("bad implementation of configureFirst in class " + this.getClass().getName() + ". Commandline is not consumed; perhaps missing skip() class. args = " + Arrays.toString(after));
                }
            } else if (!this.configureFirst(commandLine, context)) {
                context.configureLast(commandLine);
            } else {
                conf = true;
            }
            if (--maxLoops >= 0) continue;
            robustMode = true;
        }
        if (commandLine.isAutoCompleteMode()) {
            return;
        }
        if (context.isAskHelp()) {
            session.out().printlnf((Object)NutsString.of((String)this.getHelp(), (NutsSession)session));
            return;
        }
        if (context.isAskVersion()) {
            session.out().printlnf((Object)NutsIdResolver.of((NutsSession)session).resolveId(this.getClass()).getVersion().toString());
            return;
        }
        this.execBuiltin(commandLine, context);
    }

    protected void initCommandLine(NutsCommandLine commandLine) {
    }
}

