/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.toolbox.nsh.bundles._StringUtils;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellErrorHandler;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellQuitException;

public class NutsErrorHandler
implements JShellErrorHandler {
    @Override
    public boolean isQuitException(Throwable th) {
        return th instanceof JShellQuitException;
    }

    @Override
    public int errorToCode(Throwable th) {
        if (th instanceof NutsExecutionException) {
            return ((NutsExecutionException)th).getExitCode();
        }
        return 1;
    }

    @Override
    public String errorToMessage(Throwable th) {
        return _StringUtils.exceptionToString(th);
    }

    @Override
    public void onError(String message, Throwable th, JShellContext context) {
        NutsPrintStream err = context.getSession().getTerminal().err();
        err.printf("%s\n", new Object[]{NutsTexts.of((NutsSession)context.getSession()).ofStyled(message, NutsTextStyle.error())});
        err.flush();
    }
}

