/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import net.thevpc.nuts.NutsExecutableInformation;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandType;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandTypeResolver;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;

public class NutsCommandTypeResolver
implements JShellCommandTypeResolver {
    @Override
    public JShellCommandType type(String item, JShellContext context) {
        String a = context.aliases().get(item);
        if (a != null) {
            return new JShellCommandType(item, "shell alias", a, item + " is aliased to " + a);
        }
        String path = item;
        if (!item.startsWith("/")) {
            path = context.getCwd() + "/" + item;
        }
        NutsSession session = context.getSession();
        NutsExecutableInformation w = session.exec().addCommand(new String[]{item}).which();
        if (w != null) {
            return new JShellCommandType(item, "nuts " + w.getType().toString().toLowerCase(), w.getValue(), w.getDescription());
        }
        if (NutsPath.of((String)path, (NutsSession)session).exists()) {
            return new JShellCommandType(item, "path", path, item + " is " + path);
        }
        return null;
    }
}

