/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltinManager;

public class NutsBuiltinManager
implements JShellBuiltinManager {
    private static final Logger LOG = Logger.getLogger(NutsBuiltinManager.class.getName());
    private Map<String, JShellBuiltin> commands = new HashMap<String, JShellBuiltin>();

    @Override
    public JShellBuiltin find(String command) {
        return this.commands.get(command);
    }

    @Override
    public JShellBuiltin get(String cmd) {
        JShellBuiltin command = this.find(cmd);
        if (command == null) {
            throw new NoSuchElementException("builtin not found : " + cmd);
        }
        if (!command.isEnabled()) {
            throw new NoSuchElementException("builtin disabled : " + cmd);
        }
        return command;
    }

    @Override
    public boolean contains(String cmd) {
        return this.find(cmd) != null;
    }

    @Override
    public void set(JShellBuiltin command) {
        boolean b;
        boolean bl = b = this.commands.put(command.getName(), command) == null;
        if (LOG.isLoggable(Level.FINE)) {
            if (b) {
                LOG.log(Level.FINE, "registering builtin : {0}", command.getName());
            } else {
                LOG.log(Level.FINE, "unregistering builtin : {0}", command.getName());
            }
        }
    }

    @Override
    public void set(JShellBuiltin ... cmds) {
        StringBuilder installed = new StringBuilder();
        StringBuilder reinstalled = new StringBuilder();
        int installedCount = 0;
        int reinstalledCount = 0;
        boolean loggable = LOG.isLoggable(Level.FINE);
        for (JShellBuiltin command : cmds) {
            boolean b;
            boolean bl = b = this.commands.put(command.getName(), command) == null;
            if (!loggable) continue;
            if (b) {
                if (installed.length() > 0) {
                    installed.append(", ");
                }
                installed.append(command.getName());
                ++installedCount;
                continue;
            }
            if (reinstalled.length() > 0) {
                reinstalled.append(", ");
            }
            reinstalled.append(command.getName());
            ++reinstalledCount;
        }
        if (loggable) {
            if (installed.length() > 0) {
                installed.insert(0, "Registering " + installedCount + " builtin" + (installedCount > 1 ? "s" : "") + " : ");
            }
            if (reinstalled.length() > 0) {
                installed.append(" ; Unregistering ").append(reinstalledCount).append(" builtin").append(reinstalledCount > 1 ? "s" : "").append(" : ");
                installed.append((CharSequence)reinstalled);
            }
            LOG.log(Level.FINE, installed.toString());
        }
    }

    @Override
    public boolean unset(String command) {
        boolean b;
        boolean bl = b = this.commands.remove(command) != null;
        if (LOG.isLoggable(Level.FINE) && b) {
            LOG.log(Level.FINE, "Uninstalling JShellCommandNode : " + command);
        }
        return b;
    }

    @Override
    public JShellBuiltin[] getAll() {
        return this.commands.values().toArray(new JShellBuiltin[0]);
    }
}

