/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellEvaluator;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellException;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellUniformException;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStream;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStreamAdapter;

public class NshEvaluator
extends DefaultJShellEvaluator {
    @Override
    public int evalBinaryPipeOperation(final JShellCommandNode left, JShellCommandNode right, final JShellContext context) {
        JavaShellNonBlockingInputStream in2;
        NutsPrintStream nout;
        try {
            PipedOutputStream out = new PipedOutputStream();
            nout = NutsPrintStream.of((OutputStream)out, (NutsTerminalMode)NutsTerminalMode.FORMATTED, null, (NutsSession)context.getSession());
            PipedInputStream in = new PipedInputStream(out, 1024);
            in2 = in instanceof JavaShellNonBlockingInputStream ? (JavaShellNonBlockingInputStream)((Object)in) : new JavaShellNonBlockingInputStreamAdapter("jpipe-" + right.toString(), in);
        }
        catch (IOException ex) {
            throw new JShellException(context.getSession(), ex, 1);
        }
        final JShellContext leftContext = context.getShell().createNewContext(context).setOut(nout.asPrintStream());
        final JShellUniformException[] a = new JShellUniformException[2];
        Thread j1 = new Thread(){

            @Override
            public void run() {
                try {
                    context.getShell().evalNode(left, leftContext);
                }
                catch (JShellUniformException e) {
                    if (e.isQuit()) {
                        e.throwQuit();
                        return;
                    }
                    a[0] = e;
                }
                in2.noMoreBytes();
            }
        };
        j1.start();
        JShellContext rightContext = context.getShell().createNewContext(context).setIn((InputStream)((Object)in2));
        try {
            context.getShell().evalNode(right, rightContext);
        }
        catch (JShellUniformException e) {
            if (e.isQuit()) {
                e.throwQuit();
                return 0;
            }
            a[1] = e;
        }
        try {
            j1.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (a[1] != null) {
            a[1].throwAny();
        }
        return 0;
    }

    @Override
    public String evalCommandAndReturnString(JShellCommandNode command, JShellContext context) {
        DefaultJShellContext newCtx = (DefaultJShellContext)context.getShell().createNewContext(context);
        NutsSession session = newCtx.getSession().copy();
        newCtx.setSession(session);
        session.setLogTermLevel(Level.OFF);
        session.setTerminal(NutsSessionTerminal.ofMem((NutsSession)session));
        context.getShell().evalNode(command, newCtx);
        String str = this.evalFieldSubstitutionAfterCommandSubstitution(session.out().toString(), context);
        String s = context.getShell().escapeString(str);
        context.err().print(session.err().toString());
        return s;
    }
}

