/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsException;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIllegalArgumentException;
import net.thevpc.nuts.NutsMemoryPrintStream;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.toolbox.nsh.NutsCommandAutoCompleteComponent;
import net.thevpc.nuts.toolbox.nsh.bundles._IOUtils;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

public abstract class AbstractJShellBuiltin
implements JShellBuiltin {
    private static final Logger LOG = Logger.getLogger(AbstractJShellBuiltin.class.getName());
    private final String name;
    private final int supportLevel;
    private String help;
    private boolean enabled = true;

    public AbstractJShellBuiltin(String name, int supportLevel) {
        this.name = name;
        this.supportLevel = supportLevel;
    }

    protected NutsCommandLine cmdLine(String[] args, JShellExecutionContext context) {
        NutsSession session = context.getSession();
        return NutsCommandLine.of((String[])args, (NutsSession)session).setAutoComplete(context.getShellContext().getAutoComplete()).setCommandName(this.getName());
    }

    public int getSupportLevel(NutsSupportLevelContext param) {
        return this.supportLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void autoComplete(JShellExecutionContext context, NutsCommandAutoComplete autoComplete) {
        NutsCommandAutoComplete oldAutoComplete = context.getShellContext().getAutoComplete();
        context.getShellContext().setAutoComplete(autoComplete);
        try {
            if (autoComplete == null) {
                throw new NutsIllegalArgumentException(context.getSession(), NutsMessage.cstyle((String)"missing auto-complete", (Object[])new Object[0]));
            }
            NutsCommandAutoCompleteComponent best = (NutsCommandAutoCompleteComponent)context.getSession().extensions().createServiceLoader(NutsCommandAutoCompleteComponent.class, JShellBuiltin.class, NutsCommandAutoCompleteComponent.class.getClassLoader()).loadBest((Object)this);
            if (best != null) {
                best.autoComplete(this, context);
            } else {
                String[] args = autoComplete.getWords().toArray(new String[0]);
                try {
                    this.exec(args, context);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            context.getShellContext().setAutoComplete(oldAutoComplete);
        }
    }

    protected abstract void execImpl(String[] var1, JShellExecutionContext var2);

    @Override
    public final void exec(String[] args, JShellExecutionContext context) {
        try {
            this.execImpl(args, context);
        }
        catch (NutsExecutionException ex) {
            throw ex;
        }
        catch (NutsException ex) {
            throw new NutsExecutionException(context.getSession(), ex.getFormattedMessage(), (Throwable)ex, 254);
        }
        catch (Exception ex) {
            throw new NutsExecutionException(context.getSession(), NutsMessage.formatted((String)NutsTexts.of((NutsSession)context.getSession()).toText((Object)ex).toString()), (Throwable)ex, 254);
        }
    }

    @Override
    public String getHelp() {
        if (this.help == null) {
            try {
                URL resource = this.getClass().getResource("/net/thevpc/nuts/toolbox/nsh/cmd/" + this.getName() + ".ntf");
                if (resource != null) {
                    this.help = _IOUtils.loadString(resource);
                }
            }
            catch (Exception e) {
                LOG.log(Level.CONFIG, "Unable to load help for " + this.getName(), e);
            }
            if (this.help == null) {
                this.help = "```error no help found for command " + this.getName() + "```";
            }
        }
        return this.help;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String getHelpHeader() {
        block3: {
            String line;
            String h = this.getHelp();
            BufferedReader r = new BufferedReader(new StringReader(h));
            do {
                line = null;
                try {
                    line = r.readLine();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (line == null) break block3;
            } while (NutsBlankable.isBlank((String)line));
            return line;
        }
        return "No help";
    }

    protected void throwExecutionException(Object errObject, int errorCode, NutsSession session) {
        session = session.copy();
        NutsMemoryPrintStream printStream = NutsMemoryPrintStream.of((NutsSession)session);
        if (errObject != null) {
            printStream.printf(errObject);
        } else {
            printStream.printf("%s: command failed with code %s%n", new Object[]{this.getName(), errorCode});
        }
        throw new NutsExecutionException(session, NutsMessage.formatted((String)printStream.toString()), errorCode);
    }
}

