/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.thevpc.nuts.NutsInputStreamMonitor;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.lib.ssh.SshListener;
import net.thevpc.nuts.toolbox.nsh.bundles._IOUtils;

public class ShellHelper {
    public static List<NutsPath> xfilesOf(List<String> all, String cwd, NutsSession session) {
        ArrayList<NutsPath> xall = new ArrayList<NutsPath>();
        for (String v : all) {
            xall.add(ShellHelper.xfileOf(v, cwd, session));
        }
        return xall;
    }

    public static NutsPath xfileOf(String expression, String cwd, NutsSession session) {
        if (expression.startsWith("file:") || expression.contains("://")) {
            return NutsPath.of((String)expression, (NutsSession)session);
        }
        return NutsPath.of((String)_IOUtils.getAbsoluteFile2(expression, cwd), (NutsSession)session);
    }

    public static String[] splitNameAndValue(String arg) {
        int i = arg.indexOf(61);
        if (i >= 0) {
            return new String[]{i == 0 ? "" : arg.substring(0, i), i == arg.length() - 1 ? "" : arg.substring(i + 1)};
        }
        return null;
    }

    public static boolean isInt(String v1) {
        try {
            if (v1.length() == 0) {
                return false;
            }
            Integer.parseInt(v1);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean readAccept(NutsSessionTerminal t) {
        String v;
        do {
            if ((v = t.readLine("Accept (y/n) : ?", new Object[0])) == null) {
                return false;
            }
            if (!"y".equalsIgnoreCase(v = v.trim()) && !"yes".equalsIgnoreCase(v)) continue;
            return true;
        } while (!"n".equalsIgnoreCase(v) && !"no".equalsIgnoreCase(v));
        return false;
    }

    public static List<String> splitOn(String line, char sep) {
        StringTokenizer st = new StringTokenizer(line, "" + sep, true);
        ArrayList<String> ret = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String e = st.nextToken();
            if (e.charAt(0) == sep) {
                String c0 = String.valueOf(e.charAt(0));
                for (int i = e.length() - 1; i >= 0; --i) {
                    ret.add(c0);
                }
                continue;
            }
            ret.add(e);
        }
        return ret;
    }

    public static class WsSshListener
    implements SshListener {
        NutsPrintStream out;
        NutsSession session;

        public WsSshListener(NutsSession session) {
            this.session = session;
            this.out = session.out();
        }

        private boolean isTrace() {
            return this.session.isPlainTrace();
        }

        public void onExec(String command) {
            if (this.isTrace()) {
                this.out.printf("##:primary4:[SSH-EXEC]## %s\n", new Object[]{command});
            }
        }

        public void onGet(String from, String to, boolean mkdir) {
            if (this.isTrace()) {
                this.out.printf("##:primary4:[SSH-GET ]## %s -> %s\n", new Object[]{from, to});
            }
        }

        public void onPut(String from, String to, boolean mkdir) {
            if (this.isTrace()) {
                this.out.printf("##:primary4:[SSH-PUT ]## %s -> %s\n", new Object[]{from, to});
            }
        }

        public InputStream monitorInputStream(InputStream stream, long length, NutsString message) {
            return NutsInputStreamMonitor.of((NutsSession)this.session).setSource(stream).setLength(length).setName(message).create();
        }
    }
}

