/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ExecProcessInfo;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStream;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ProcessWatcher;

public class ProcessWatcher2
extends ProcessWatcher {
    private Process process;
    private CloseableThread end;
    private CloseableThread in;
    private CloseableThread out;
    private CloseableThread err;
    private int result;
    private Throwable resultError;
    private boolean stopped = false;
    private boolean endStreamOut = false;
    private boolean endStreamErr = false;
    private boolean endStreamIn = false;
    private ExecProcessInfo info;

    public ProcessWatcher2(Process process, ExecProcessInfo info) {
        this.info = info;
        this.process = process;
    }

    public void waitForStreams() {
        long timeEnded = System.currentTimeMillis();
        while (!(this.endStreamOut && this.endStreamErr && this.endStreamIn)) {
            long now = System.currentTimeMillis();
            if (now - timeEnded > 3000L) {
                StringBuilder s = new StringBuilder(this.info.cmdarray[0]);
                s.append(" ");
                s.append("stream(s) still open :");
                if (!this.endStreamOut) {
                    s.append(" stdout");
                    this.out.close();
                    this.out.interrupt();
                }
                if (!this.endStreamErr) {
                    s.append(" stderr");
                    this.err.close();
                    this.err.interrupt();
                }
                if (!this.endStreamIn) {
                    s.append(" stdin");
                    this.in.close();
                    this.in.interrupt();
                }
                this.logError(s.toString());
                this.endStreamOut = true;
                this.endStreamErr = true;
                this.endStreamIn = true;
            } else if (now - timeEnded > 2000L) {
                if (!this.endStreamOut) {
                    this.out.close();
                }
                if (!this.endStreamErr) {
                    this.err.close();
                }
                if (this.endStreamIn) break;
                this.in.close();
                break;
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                break;
            }
        }
    }

    protected void logInfo(String s) {
        System.out.printf("[logInfo] %s\n", s);
    }

    protected void logError(String s) {
        System.err.printf("[logError] %s\n", s);
    }

    protected void logError(Throwable s) {
        System.err.printf("[logError] %s \n", s.toString());
    }

    public void start() {
        this.end = new CloseableThread("pw-end-" + this.info.cmdarray[0]){

            @Override
            public void run() {
                try {
                    ProcessWatcher2.this.result = ProcessWatcher2.this.process.waitFor();
                }
                catch (Throwable e) {
                    ProcessWatcher2.this.resultError = e;
                    ProcessWatcher2.this.logError(e.toString());
                }
                finally {
                    ProcessWatcher2.this.stopped = true;
                }
                this.close();
            }

            @Override
            public void close() {
                this.closed = true;
                ProcessWatcher2.this.waitForStreams();
            }
        };
        this.out = new CloseableThread("pw-out-" + this.info.cmdarray[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InputStream in = ProcessWatcher2.this.process.getInputStream();
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    try {
                        while ((len = in.read(buffer)) > 0) {
                            ((ProcessWatcher2)ProcessWatcher2.this).info.out.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable e) {
                        ProcessWatcher2.this.logError(e);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProcessWatcher2.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                finally {
                    ProcessWatcher2.this.endStreamOut = true;
                }
            }

            @Override
            public void close() {
                this.closed = true;
                try {
                    ProcessWatcher2.this.process.getInputStream().close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProcessWatcher2.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.err = new CloseableThread("pw-err-" + this.info.cmdarray[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    InputStream in = ProcessWatcher2.this.process.getErrorStream();
                    byte[] buffer = new byte[1024];
                    int len = 0;
                    try {
                        while ((len = in.read(buffer)) > 0) {
                            ((ProcessWatcher2)ProcessWatcher2.this).info.err.write(buffer, 0, len);
                        }
                    }
                    catch (Throwable e) {
                        ProcessWatcher2.this.logError(e);
                    }
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProcessWatcher2.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                finally {
                    ProcessWatcher2.this.endStreamErr = true;
                }
            }

            @Override
            public void close() {
                this.closed = true;
                try {
                    ProcessWatcher2.this.process.getErrorStream().close();
                }
                catch (IOException ex) {
                    Logger.getLogger(ProcessWatcher2.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
        this.in = new CloseableThread("pw-in-" + this.info.cmdarray[0]){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OutputStream out;
                    block15: {
                        InputStream in = ((ProcessWatcher2)ProcessWatcher2.this).info.in;
                        out = ProcessWatcher2.this.process.getOutputStream();
                        byte[] buffer = new byte[1024];
                        int len = 0;
                        try {
                            if (in instanceof JavaShellNonBlockingInputStream) {
                                JavaShellNonBlockingInputStream ine = (JavaShellNonBlockingInputStream)((Object)in);
                                while (!ProcessWatcher2.this.stopped && ine.hasMoreBytes()) {
                                    int available = in.available();
                                    if (available > 0) {
                                        len = in.read(buffer);
                                        if (len > 0) {
                                            out.write(buffer, 0, len);
                                            continue;
                                        }
                                    } else {
                                        len = ((JavaShellNonBlockingInputStream)((Object)in)).readNonBlocking(buffer, 0, buffer.length, 3000L);
                                        if (len > 0) {
                                            out.write(buffer, 0, len);
                                            continue;
                                        }
                                    }
                                    break block15;
                                }
                                break block15;
                            }
                            while (!ProcessWatcher2.this.stopped) {
                                int available = in.available();
                                if (available <= 0) continue;
                                len = in.read(buffer);
                                if (len > 0) {
                                    out.write(buffer, 0, len);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (Throwable e) {
                            ProcessWatcher2.this.logError(e);
                        }
                    }
                    try {
                        out.close();
                    }
                    catch (Exception ex) {
                        Logger.getLogger(ProcessWatcher2.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                finally {
                    ProcessWatcher2.this.endStreamIn = true;
                }
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
        this.end.start();
        this.out.start();
        this.err.start();
        this.in.start();
    }

    public int waitfor() {
        while (!(this.stopped && this.endStreamOut && this.endStreamErr && this.endStreamIn)) {
            Thread.yield();
        }
        return this.result;
    }

    public static abstract class CloseableThread
    extends Thread {
        public boolean closed;

        public CloseableThread(String name) {
            super(name);
        }

        public abstract void close();
    }
}

