/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ProcessStringsHandler;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ProcessWatcher;

public class ProcessWatcher1
extends ProcessWatcher {
    private Process process;
    private Thread end;
    private Thread out;
    private Thread err;
    private int result;
    private Throwable resultError;
    private boolean stopped = false;
    private boolean endStreamOut = false;
    private boolean endStreamErr = false;
    private ProcessStringsHandler stringsHandler;

    public ProcessWatcher1(Process theProcess, ProcessStringsHandler theHandler) {
        this.process = theProcess;
        this.stringsHandler = theHandler;
    }

    public void waitForStreams() {
        long timeEnded = System.currentTimeMillis();
        while (!this.endStreamOut || !this.endStreamErr) {
            long now = System.currentTimeMillis();
            if (now - timeEnded <= 10000L) continue;
            this.stringsHandler.error(this.process, new Throwable("endStreamOut=" + this.endStreamOut + "; endStreamErr=" + this.endStreamErr));
            break;
        }
    }

    public void start() {
        this.stringsHandler.started(this.process);
        this.end = new Thread(){

            @Override
            public void run() {
                try {
                    ProcessWatcher1.this.result = ProcessWatcher1.this.process.waitFor();
                }
                catch (Throwable e) {
                    ProcessWatcher1.this.resultError = e;
                    ProcessWatcher1.this.stringsHandler.error(ProcessWatcher1.this.process, e);
                }
                finally {
                    ProcessWatcher1.this.stopped = true;
                }
                ProcessWatcher1.this.waitForStreams();
                ProcessWatcher1.this.stringsHandler.ended(ProcessWatcher1.this.process, ProcessWatcher1.this.result);
            }
        };
        this.out = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BufferedReader in = new BufferedReader(new InputStreamReader(ProcessWatcher1.this.process.getInputStream()));
                    try {
                        String read;
                        while ((read = in.readLine()) != null) {
                            ProcessWatcher1.this.stringsHandler.stdout(ProcessWatcher1.this.process, read);
                        }
                    }
                    catch (Throwable e) {
                        ProcessWatcher1.this.stringsHandler.error(ProcessWatcher1.this.process, e);
                    }
                }
                finally {
                    ProcessWatcher1.this.endStreamOut = true;
                }
            }
        };
        this.err = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(ProcessWatcher1.this.process.getErrorStream()));
                    try {
                        String read;
                        while ((read = in.readLine()) != null) {
                            ProcessWatcher1.this.stringsHandler.stderr(ProcessWatcher1.this.process, read);
                        }
                    }
                    catch (Throwable e) {
                        ProcessWatcher1.this.stringsHandler.error(ProcessWatcher1.this.process, e);
                    }
                }
                catch (Throwable e) {
                    ProcessWatcher1.this.stringsHandler.error(ProcessWatcher1.this.process, e);
                }
                finally {
                    ProcessWatcher1.this.endStreamErr = true;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            ProcessWatcher1.this.stringsHandler.error(ProcessWatcher1.this.process, e);
                        }
                    }
                }
            }
        };
        this.end.start();
        this.out.start();
        this.err.start();
    }

    public int waitfor() {
        while (!(this.stopped && this.endStreamOut && this.endStreamErr)) {
            Thread.yield();
        }
        return this.result;
    }
}

