/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStream;

public class JavaShellNonBlockingInputStreamAdapter
extends FilterInputStream
implements JavaShellNonBlockingInputStream {
    private boolean hasMoreBytes = true;
    private boolean closed = false;
    private String name;

    public JavaShellNonBlockingInputStreamAdapter(String name, InputStream in) {
        super(in);
        this.name = name;
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = super.read();
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = -1;
        try {
            read = super.read(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return -1;
        }
        int read = -1;
        try {
            read = super.read(b, off, len);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (read < 0) {
            this.hasMoreBytes = false;
        }
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.available() == 0 && !this.hasMoreBytes()) {
            return 0L;
        }
        return super.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return -1;
        }
        int available = -1;
        try {
            available = super.available();
        }
        catch (IOException ex) {
            return -1;
        }
        if (available < 0) {
            if (!this.closed) {
                this.close();
            }
            return -1;
        }
        if (available == 0 && !this.hasMoreBytes) {
            return -1;
        }
        if (this.closed) {
            return -1;
        }
        return available;
    }

    @Override
    public int readNonBlocking(byte[] b, long timeout) throws IOException {
        return this.readNonBlocking(b, 0, b.length, timeout);
    }

    @Override
    public int readNonBlocking(byte[] b, int off, int len, long timeout) throws IOException {
        long now = System.currentTimeMillis();
        long then = now + timeout;
        long tic = 100L;
        while (!this.closed) {
            int available = this.available();
            if (available < 0) {
                this.hasMoreBytes = false;
                break;
            }
            if (available > 0) {
                return this.read(b, off, len);
            }
            if (!this.hasMoreBytes() || (now = System.currentTimeMillis()) > then) break;
            try {
                Thread.sleep(tic);
            }
            catch (InterruptedException e) {
                break;
            }
        }
        return 0;
    }

    @Override
    public void noMoreBytes() {
        this.hasMoreBytes = false;
    }

    @Override
    public boolean hasMoreBytes() {
        return this.hasMoreBytes;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.hasMoreBytes = false;
        this.closed = true;
    }
}

