/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IOPipe {
    private PipedOutputStream out;
    private PipedInputStream in;

    public static IOPipe createPipe(int size) throws IOException {
        IOPipe p = new IOPipe();
        p.in = new PipedInputStream(size);
        p.out = new PipedOutputStream(p.in);
        return p;
    }

    public PipedOutputStream getOut() {
        return this.out;
    }

    public PipedInputStream getIn() {
        return this.in;
    }

    public static void asyncCopy(final InputStream in, final OutputStream out) throws IOException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOPipe.copy(in, out);
                }
                catch (IOException ex) {
                    Logger.getLogger(IOPipe.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }).start();
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
    }
}

