/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell.parser.ctx;

import net.thevpc.nuts.toolbox.nsh.jshell.parser.AbstractContext;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.JShellParser;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.StrReader;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.Token;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.ctx.AntiQuotedContext;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.ctx.DollarCurlBracketContext;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.ctx.DollarPar2Context;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.ctx.DollarParContext;

public class DoubleQuotedContext
extends AbstractContext {
    public DoubleQuotedContext(JShellParser jshp) {
        super(jshp);
    }

    @Override
    public Token nextToken() {
        StrReader reader = this.reader.strReader();
        int r = reader.peekChar();
        if (r < 0) {
            return null;
        }
        char rc = (char)r;
        if (reader.readString("$((")) {
            return this.reader.lexer().processContext("$((", new DollarPar2Context(this.reader));
        }
        if (reader.readString("$(")) {
            return this.reader.lexer().processContext("$(", new DollarParContext(this.reader));
        }
        if (reader.readString("${")) {
            return this.reader.lexer().processContext("${", new DollarCurlBracketContext(this.reader));
        }
        if (rc == '$') {
            return this.reader.lexer().continueReadDollarWord();
        }
        if (rc == '\"') {
            reader.read();
            return null;
        }
        if (rc == '`') {
            reader.read();
            return this.reader.lexer().processContext(String.valueOf(rc), new AntiQuotedContext(this.reader));
        }
        StringBuilder sb = new StringBuilder();
        while ((r = reader.peekChar()) >= 0 && this.isDblQChar(rc = (char)r)) {
            sb.append((char)reader.read());
        }
        if (sb.length() == 0) {
            return null;
        }
        return new Token("STR", sb.toString(), sb.toString());
    }

    boolean isDblQChar(char c) {
        switch (c) {
            case '\"': 
            case '$': 
            case '\'': {
                return false;
            }
        }
        return true;
    }
}

