/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVar;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVarListener;

public class JShellVariables {
    private Map<String, JShellVar> vars = new HashMap<String, JShellVar>();
    private List<JShellVarListener> listeners = new ArrayList<JShellVarListener>();
    private JShellContext shellContext;

    public JShellVariables(JShellContext shellContext) {
        this.shellContext = shellContext;
    }

    public void addVarListener(JShellVarListener listener) {
        this.listeners.add(listener);
    }

    public void removeVarListener(JShellVarListener listener) {
        this.listeners.add(listener);
    }

    public JShellVarListener[] getVarListeners() {
        return this.listeners.toArray(new JShellVarListener[0]);
    }

    public void setParent(JShellVariables parent) {
        if (parent != null) {
            for (JShellVar value : parent.vars.values()) {
                this.vars.put(value.getName(), new JShellVar(this, value.getName(), value.getValue(), value.isExported()));
            }
        }
    }

    public JShellVar getVar(String name) {
        JShellVar v = this.findVar(name);
        if (v == null) {
            throw new NoSuchElementException("not found " + name);
        }
        return v;
    }

    public JShellVar findVar(String name) {
        JShellVar t = this.vars.get(name);
        if (t != null) {
            return t;
        }
        return null;
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        JShellVar v = this.findVar(name);
        if (v != null) {
            return v.getValue();
        }
        return defaultValue;
    }

    public Properties getExported() {
        Properties all = new Properties();
        for (JShellVar value : this.vars.values()) {
            if (!value.isExported()) continue;
            all.put(value.getName(), value.getValue());
        }
        return all;
    }

    public Properties getAll() {
        Properties all = new Properties();
        for (JShellVar value : this.vars.values()) {
            all.put(value.getName(), value.getValue());
        }
        return all;
    }

    public void set(Map<String, String> env) {
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            this.set(key, entry.getValue());
            if (!this.vars.containsKey(key)) continue;
            this.export(key);
        }
    }

    public void export(String var, String value) {
        JShellVar b = this.findVar(var);
        if (value == null) {
            value = var;
        }
        if (b == null) {
            this.vars.put(var, new JShellVar(this, var, value, true));
        } else {
            b.setValue(value);
            b.setExported(true);
        }
    }

    public void set(String var, String value) {
        this.set(var, value, false);
    }

    public void set(String var, String value, boolean defaultExport) {
        block6: {
            JShellVar b;
            block5: {
                b = this.findVar(var);
                if (b == null && value == null) {
                    return;
                }
                if (b != null) break block5;
                JShellVar jvar = new JShellVar(this, var, value, defaultExport);
                this.vars.put(var, jvar);
                for (JShellVarListener listener : this.getVarListeners()) {
                    listener.varAdded(jvar, this, this.shellContext);
                }
                for (JShellVarListener listener : this.shellContext.getShell().getVarListeners()) {
                    listener.varAdded(jvar, this, this.shellContext);
                }
                break block6;
            }
            String oldValue = b.getValue();
            if (Objects.equals(oldValue, value)) break block6;
            b.setValue(value);
            for (JShellVarListener listener : this.getVarListeners()) {
                listener.varValueUpdated(b, oldValue, this, this.shellContext);
            }
            for (JShellVarListener listener : this.shellContext.getShell().getVarListeners()) {
                listener.varValueUpdated(b, oldValue, this, this.shellContext);
            }
        }
    }

    public void export(String var) {
        JShellVar b = this.findVar(var);
        if (b == null) {
            this.set(var, var, true);
        } else if (!b.isExported()) {
            b.setExported(true);
            for (JShellVarListener listener : this.getVarListeners()) {
                listener.varExportUpdated(b, false, this, this.shellContext);
            }
            for (JShellVarListener listener : this.shellContext.getShell().getVarListeners()) {
                listener.varExportUpdated(b, false, this, this.shellContext);
            }
        }
    }

    public void unexport(String var) {
        if (this.vars.containsKey(var)) {
            JShellVar jvar = this.getVar(var);
            if (jvar.isExported()) {
                jvar.setExported(false);
            }
            for (JShellVarListener listener : this.getVarListeners()) {
                listener.varExportUpdated(jvar, false, this, this.shellContext);
            }
            for (JShellVarListener listener : this.shellContext.getShell().getVarListeners()) {
                listener.varExportUpdated(jvar, false, this, this.shellContext);
            }
        } else {
            throw new NoSuchElementException("Unable to unexport env var " + var + " . Not found");
        }
    }

    public boolean isExported(String var) {
        JShellVar v = this.findVar(var);
        return v != null && v.isExported();
    }

    public void set(JShellVariables other) {
        for (Map.Entry<Object, Object> entry : other.getAll().entrySet()) {
            String key = (String)entry.getKey();
            this.set(key, (String)entry.getValue());
            if (!other.isExported(key)) continue;
            this.export(key);
        }
    }

    public void clear() {
    }

    void varValueChanged(JShellVar svar, String oldValue) {
        if (svar.getValue() == null) {
            this.vars.remove(svar.getName());
        }
    }

    void varEnabledChanged(JShellVar aThis) {
    }
}

