/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandAutoCompleteResolver;
import net.thevpc.nuts.NutsCommandHistory;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsIdResolver;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsSessionTerminal;
import net.thevpc.nuts.NutsStoreLocation;
import net.thevpc.nuts.NutsString;
import net.thevpc.nuts.NutsSystemTerminal;
import net.thevpc.nuts.NutsTextStyle;
import net.thevpc.nuts.NutsTexts;
import net.thevpc.nuts.spi.NutsDefaultSupportLevelContext;
import net.thevpc.nuts.spi.NutsSupportLevelContext;
import net.thevpc.nuts.toolbox.nsh.Nsh;
import net.thevpc.nuts.toolbox.nsh.NshEvaluator;
import net.thevpc.nuts.toolbox.nsh.NutsCommandTypeResolver;
import net.thevpc.nuts.toolbox.nsh.NutsErrorHandler;
import net.thevpc.nuts.toolbox.nsh.NutsExternalExecutor;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellCommandTypeResolver;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellErrorHandler;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellEvaluator;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellHistory;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellOptionsParser;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellArgumentNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandLineNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandTypeResolver;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContextForSource;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellErrorHandler;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellEvaluator;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellException;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExternalExecutor;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellHistory;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellOptions;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellOptionsParser;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellQuitException;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellResult;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellScript;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellUniformException;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVarListener;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellVariables;
import net.thevpc.nuts.toolbox.nsh.jshell.MemResult;
import net.thevpc.nuts.toolbox.nsh.jshell.NshAutoCompleter;
import net.thevpc.nuts.toolbox.nsh.jshell.parser.JShellParser;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ByteArrayPrintStream;

public class JShell {
    public static final String APP_VERSION = "0.4";
    public static final String ENV_PATH = "PATH";
    public static final String ENV_HOME = "HOME";
    private static final Logger LOG = Logger.getLogger(JShell.class.getName());
    private final JShellOptions options;
    private final JShellHistory history;
    private final List<JShellVarListener> listeners = new ArrayList<JShellVarListener>();
    protected JShellContext rootContext;
    long boot_startMillis;
    private JShellEvaluator evaluator;
    private JShellErrorHandler errorHandler;
    private JShellExternalExecutor externalExecutor;
    private JShellCommandTypeResolver commandTypeResolver;
    private NutsApplicationContext appContext;
    private NutsPath histFile = null;
    private NutsId appId = null;

    public JShell(NutsApplicationContext appContext) {
        this(appContext, null);
    }

    public JShell(NutsApplicationContext appContext, String[] args) {
        this(appContext, appContext.getAppId(), appContext.getAppId().getArtifactId(), args);
    }

    public JShell(NutsSession session, String[] args) {
        this(NutsApplicationContext.of((String[])new String[0], (long)0L, Nsh.class, null, (NutsSession)session), null, null, args);
    }

    public JShell(NutsSession session, NutsId appId, String[] args) {
        this(NutsApplicationContext.of((String[])new String[0], (long)0L, Nsh.class, null, (NutsSession)session), appId, appId == null ? null : appId.getArtifactId(), args);
    }

    public JShell(NutsSession session, NutsId appId, String serviceName, String[] args) {
        this(NutsApplicationContext.of((String[])new String[0], (long)0L, Nsh.class, null, (NutsSession)session), appId, serviceName, args);
    }

    private JShell(NutsApplicationContext appContext, NutsId appId, String serviceName, String[] args) {
        this(JShell.resolveServiceName(appContext, serviceName, appId), JShell.resolveArgs(appContext, args), new DefaultJShellOptionsParser(appContext), new NshEvaluator(), new NutsCommandTypeResolver(), new NutsErrorHandler(), new NutsExternalExecutor(), null);
        this.boot_startMillis = appContext.getStartTimeMillis();
        this.appContext = appContext;
        this.appId = appId;
        if (this.appId == null) {
            this.appId = NutsIdResolver.of((NutsSession)appContext.getSession()).resolveId(JShell.class);
        }
        if (this.appId == null) {
            throw new IllegalArgumentException("unable to resolve application id");
        }
        JShellContext _rootContext = this.getRootContext();
        NutsSession ws = _rootContext.getSession();
        JShellHistory hist = this.getHistory();
        this.appContext.getSession().env().setProperty(JShellContext.class.getName(), (Object)_rootContext);
        _rootContext.setSession(appContext.getSession());
        ArrayList<JShellBuiltin> allCommand = new ArrayList<JShellBuiltin>();
        NutsDefaultSupportLevelContext constraints = new NutsDefaultSupportLevelContext(appContext.getSession(), (Object)this);
        for (JShellBuiltin command : this.appContext.getSession().extensions().createServiceLoader(JShellBuiltin.class, JShell.class, JShellBuiltin.class.getClassLoader()).loadAll((Object)this)) {
            JShellBuiltin old = _rootContext.builtins().find(command.getName());
            if (old != null && old.getSupportLevel((NutsSupportLevelContext)constraints) >= command.getSupportLevel((NutsSupportLevelContext)constraints)) continue;
            allCommand.add(command);
        }
        _rootContext.builtins().set(allCommand.toArray(new JShellBuiltin[0]));
        _rootContext.getUserProperties().put(JShellContext.class.getName(), _rootContext);
        try {
            this.histFile = ws.locations().getStoreLocation(this.appId, NutsStoreLocation.VAR).resolve((serviceName == null ? "" : serviceName) + ".history");
            hist.setHistoryFile(this.histFile);
            if (this.histFile.exists()) {
                hist.load(this.histFile);
            }
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "error resolving history file", ex);
        }
        ws.env().setProperty(JShellHistory.class.getName(), (Object)hist);
    }

    public JShell() {
        this(null, null, null, null, null, null, null, null);
    }

    public JShell(String serviceName, String[] args, JShellOptionsParser shellOptionsParser, JShellEvaluator evaluator, JShellCommandTypeResolver commandTypeResolver, JShellErrorHandler errorHandler, JShellExternalExecutor externalExecutor, JShellHistory history) {
        this.commandTypeResolver = commandTypeResolver == null ? new DefaultJShellCommandTypeResolver() : commandTypeResolver;
        this.errorHandler = errorHandler == null ? new DefaultJShellErrorHandler() : errorHandler;
        this.evaluator = evaluator == null ? new DefaultJShellEvaluator() : evaluator;
        this.history = history == null ? new DefaultJShellHistory() : history;
        if (shellOptionsParser == null) {
            shellOptionsParser = new DefaultJShellOptionsParser(this.appContext);
        }
        this.options = shellOptionsParser.parse(args);
        this.externalExecutor = externalExecutor;
        if (this.options.getServiceName() == null) {
            this.options.setServiceName(serviceName == null ? "jshell" : serviceName);
        }
    }

    private static String[] resolveArgs(NutsApplicationContext appContext, String[] args) {
        if (args != null) {
            return args;
        }
        return appContext.getArguments();
    }

    private static String resolveServiceName(NutsApplicationContext appContext, String serviceName, NutsId appId) {
        if (serviceName == null || serviceName.trim().isEmpty()) {
            if (appId == null) {
                appId = NutsIdResolver.of((NutsSession)appContext.getSession()).resolveId(JShell.class);
            }
            serviceName = appId.getArtifactId();
        }
        return serviceName;
    }

    public void addVarListener(JShellVarListener listener) {
        this.listeners.add(listener);
    }

    public void removeVarListener(JShellVarListener listener) {
        this.listeners.add(listener);
    }

    public JShellVarListener[] getVarListeners() {
        return this.listeners.toArray(new JShellVarListener[0]);
    }

    public JShellEvaluator getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(JShellEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public JShellCommandTypeResolver getCommandTypeResolver() {
        return this.commandTypeResolver;
    }

    public void setCommandTypeResolver(JShellCommandTypeResolver whichResolver) {
        this.commandTypeResolver = whichResolver;
    }

    public JShellExternalExecutor getExternalExecutor() {
        return this.externalExecutor;
    }

    public void setExternalExecutor(JShellExternalExecutor externalExecutor) {
        this.externalExecutor = externalExecutor;
    }

    public JShellErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(JShellErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public List<String> findFiles(String namePattern, boolean exact, String parent, NutsSession session) {
        if (exact) {
            String[] all = (String[])NutsPath.of((String)parent, (NutsSession)session).list().filter(x -> namePattern.equals(x.getName()), "name='" + namePattern + "'").map(NutsPath::toString, "toString").toArray(String[]::new);
            return Arrays.asList(all);
        }
        Pattern o = Pattern.compile(namePattern);
        String[] all = (String[])NutsPath.of((String)parent, (NutsSession)session).list().filter(x -> o.matcher(x.getName()).matches(), "name~~'" + namePattern + "'").map(NutsPath::toString, "toString").toArray(String[]::new);
        return Arrays.asList(all);
    }

    protected JShellContext createRootContext(String serviceName, String[] args) {
        return this.createContext(null, null, null, null, serviceName, args);
    }

    public JShellContext createNewContext(JShellContext parentContext) {
        return this.createNewContext(parentContext, parentContext.getServiceName(), parentContext.getArgsArray());
    }

    public JShellContext createNewContext(JShellContext ctx, String serviceName, String[] args) {
        return this.createContext(ctx, null, null, null, serviceName, args);
    }

    public JShellContext createInlineContext(JShellContext ctx, String serviceName, String[] args) {
        if (ctx == null) {
            ctx = this.getRootContext();
        }
        JShellContextForSource c = new JShellContextForSource(ctx);
        c.setServiceName(serviceName);
        c.setArgs(args);
        return c;
    }

    public JShellCommandNode createCommandNode(String[] args) {
        return JShellParser.createCommandNode(args);
    }

    public JShellContext getRootContext() {
        if (this.rootContext == null) {
            this.rootContext = this.createRootContext(this.options.getServiceName(), this.options.getCommandArgs().toArray(new String[0]));
        }
        return this.rootContext;
    }

    public void executeLine(String line, boolean storeResult, JShellContext context) {
        if (context == null) {
            context = this.getRootContext();
        }
        boolean success = false;
        if (line.trim().length() > 0 && !line.trim().startsWith("#")) {
            try {
                this.getHistory().add(line);
                JShellScript nn = this.parseScript(line);
                context.getShell().evalNode(nn, context);
                success = true;
            }
            catch (JShellQuitException e) {
                throw e;
            }
            catch (Throwable e) {
                if (storeResult) {
                    this.onResult(e, context);
                }
                if (e instanceof RuntimeException) {
                    throw e;
                }
                if (e instanceof Error) {
                    throw e;
                }
                throw new RuntimeException(e);
            }
            if (storeResult && success) {
                this.onResult(null, context);
                try {
                    this.history.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public int onResult(int r, JShellContext context) {
        context.setLastResult(new JShellResult(r, null, null));
        return r;
    }

    public int onResult(Throwable th, JShellContext context) {
        if (th == null) {
            context.setLastResult(new JShellResult(0, null, null));
            return 0;
        }
        if (th instanceof JShellQuitException) {
            throw (JShellQuitException)((Object)th);
        }
        if (this.getErrorHandler().isQuitException(th)) {
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new JShellQuitException(context.getSession(), th, 100);
        }
        if (th instanceof JShellException) {
            JShellException je = (JShellException)((Object)th);
            int errorCode = je.getExitCode();
            String lastErrorMessage = this.getErrorHandler().errorToMessage(th);
            context.setLastResult(new JShellResult(errorCode, lastErrorMessage, th));
            if (errorCode != 0) {
                this.getErrorHandler().onError(lastErrorMessage, th, context);
            }
            return errorCode;
        }
        int errorCode = this.getErrorHandler().errorToCode(th);
        String lastErrorMessage = this.getErrorHandler().errorToMessage(th);
        context.setLastResult(new JShellResult(errorCode, lastErrorMessage, th));
        if (errorCode != 0) {
            this.getErrorHandler().onError(lastErrorMessage, th, context);
        }
        return errorCode;
    }

    public int onResult(int errorCode, Throwable th, JShellContext context) {
        if (errorCode != 0) {
            if (th == null) {
                th = new RuntimeException("error occurred. Error Code #" + errorCode);
            }
        } else {
            th = null;
        }
        String lastErrorMessage = th == null ? null : this.getErrorHandler().errorToMessage(th);
        context.setLastResult(new JShellResult(errorCode, lastErrorMessage, th));
        if (errorCode != 0) {
            this.getErrorHandler().onError(lastErrorMessage, th, context);
        }
        return errorCode;
    }

    public int executeCommand(String[] command, JShellContext context) {
        context.setServiceName(command[0]);
        context.setArgs(Arrays.copyOfRange(command, 1, command.length));
        return context.getShell().evalNode(this.createCommandNode(command), context);
    }

    public void addToHistory(String[] command) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            String arg = command[i];
            if (i > 0) {
                sb.append(" ");
            }
            if (arg.contains(" ")) {
                sb.append("\"").append(arg).append("\"");
                continue;
            }
            sb.append(arg);
        }
        this.getHistory().add(sb.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int executePreparedCommand(String[] command, boolean considerAliases, boolean considerBuiltins, boolean considerExternal, JShellContext context) {
        JShellBuiltin shellCommand;
        String a;
        context.getShell().traceExecution(() -> String.join((CharSequence)" ", command), context);
        String cmdToken = command[0];
        NutsPath cmdPath = NutsPath.of((String)cmdToken, (NutsSession)context.getSession());
        if (!cmdPath.isName()) {
            JShellExternalExecutor externalExec = this.getExternalExecutor();
            if (externalExec != null) return externalExec.execExternalCommand(command, context);
            throw new JShellException(context.getSession(), NutsMessage.cstyle((String)"not found %s", (Object[])new Object[]{cmdToken}), 101);
        }
        ArrayList<String> cmds = new ArrayList<String>(Arrays.asList(command));
        String string = a = considerAliases ? context.aliases().get(cmdToken) : null;
        if (a != null) {
            JShellNode node0 = null;
            try {
                node0 = JShellParser.fromString(a).parse();
            }
            catch (Exception ex) {
                Logger.getLogger(JShell.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (!(node0 instanceof JShellCommandLineNode)) throw new IllegalArgumentException("invalid  alias " + a);
            JShellCommandLineNode nn = (JShellCommandLineNode)node0;
            ArrayList<String> newCmd = new ArrayList<String>();
            for (JShellArgumentNode item : nn) {
                newCmd.addAll(Arrays.asList(item.evalString(context)));
            }
            for (int i = 1; i < cmds.size(); ++i) {
                newCmd.add((String)cmds.get(i));
            }
            cmds.clear();
            cmds.addAll(newCmd);
        } else {
            a = cmdToken;
        }
        JShellBuiltin jShellBuiltin = shellCommand = considerBuiltins ? context.builtins().find(a) : null;
        if (shellCommand != null && shellCommand.isEnabled()) {
            ArrayList<String> arg2 = new ArrayList<String>(cmds);
            arg2.remove(0);
            shellCommand.exec(arg2.toArray(new String[0]), context.createCommandContext(shellCommand));
            return 0;
        } else {
            if (!considerExternal) throw new JShellException(context.getSession(), NutsMessage.cstyle((String)"not found %s", (Object[])new Object[]{cmdToken}), 101);
            JShellExternalExecutor externalExec = this.getExternalExecutor();
            if (externalExec == null) {
                throw new JShellException(context.getSession(), NutsMessage.cstyle((String)"not found %s", (Object[])new Object[]{cmdToken}), 101);
            }
            externalExec.execExternalCommand(cmds.toArray(new String[0]), context);
        }
        return 0;
    }

    public void run() {
        try {
            if (this.appContext.getAutoComplete() != null) {
                return;
            }
            JShellContext rootContext = this.getRootContext();
            if (this.getOptions().isHelp()) {
                this.executeHelp(rootContext);
                return;
            }
            if (this.getOptions().isVersion()) {
                this.executeVersion(rootContext);
                return;
            }
            if (this.getOptions().isStdInAndPos()) {
                if (this.getOptions().getCommandArgs().isEmpty()) {
                    this.executeInteractive(rootContext);
                } else {
                    rootContext.err().println("-s option not supported yet. ignored");
                    this.executeInteractive(rootContext);
                }
                if (this.getOptions().isInteractive()) {
                    this.executeInteractive(rootContext);
                }
                return;
            }
            if (this.getOptions().isCommand()) {
                this.executeCommand(this.getOptions().getCommandArgs().toArray(new String[0]), rootContext);
                if (this.getOptions().isInteractive()) {
                    this.executeInteractive(rootContext);
                }
                return;
            }
            if (!this.getOptions().getFiles().isEmpty()) {
                for (String file : this.getOptions().getFiles()) {
                    this.executeServiceFile(this.createNewContext(rootContext, file, this.getOptions().getCommandArgs().toArray(new String[0])), false);
                }
                if (this.getOptions().isInteractive()) {
                    this.executeInteractive(rootContext);
                }
                return;
            }
            this.executeInteractive(rootContext);
        }
        catch (NutsExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new NutsExecutionException(this.appContext.getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 100);
        }
    }

    protected String readInteractiveLine(JShellContext context) {
        NutsSessionTerminal terminal = context.getSession().getTerminal();
        return terminal.readLine(this.getPromptString(context), new Object[0]);
    }

    protected void printHeader(NutsPrintStream out) {
        out.resetLine().println((NutsString)NutsTexts.of((NutsSession)this.appContext.getSession()).builder().appendCode("sh", "nuts").append((Object)" shell ").append((Object)("v" + this.getRootContext().getWorkspace().getRuntimeId().getVersion().toString()), NutsTextStyle.version()).append((Object)" (c) thevpc 2019-2021"));
    }

    protected void executeHelp(JShellContext context) {
        context.out().println("Syntax : shell [<FILE>]\n");
        context.out().println("    <FILE> : if present content will be processed as input\n");
    }

    protected void executeVersion(JShellContext context) {
        context.out().printf("v%s\n", new Object[]{APP_VERSION});
    }

    protected void executeInteractive(JShellContext context) {
        NutsSession session = this.appContext.getSession();
        NutsSystemTerminal.enableRichTerm((NutsSession)session);
        session.config().getSystemTerminal().setCommandAutoCompleteResolver((NutsCommandAutoCompleteResolver)new NshAutoCompleter()).setCommandHistory(NutsCommandHistory.of((NutsSession)session).setPath(this.appContext.getVarFolder().resolve("nsh-history.hist")));
        this.prepareContext(this.getRootContext());
        this.printHeader(context.out());
        if (this.getOptions().isLogin()) {
            this.executeLoginScripts();
        }
        while (true) {
            String line = null;
            try {
                line = this.readInteractiveLine(context);
            }
            catch (Exception ex) {
                this.onResult(ex, context);
                break;
            }
            if (line == null) break;
            if (line.trim().length() <= 0) continue;
            try {
                this.executeLine(line, true, context);
            }
            catch (JShellQuitException q) {
                if (this.getOptions().isLogin()) {
                    this.executeLogoutScripts();
                }
                if (q.getExitCode() == 0) {
                    return;
                }
                this.onQuit(q);
                return;
            }
        }
        if (this.getOptions().isLogin()) {
            this.executeLogoutScripts();
        }
        this.onQuit(new JShellQuitException(session, 1));
    }

    private void executeLoginScripts() {
        if (!this.getOptions().isNoProfile()) {
            for (String profileFile : new String[]{"/etc/profile", this.getOptions().isPosix() ? null : "~/.bash_profile", this.getOptions().isPosix() ? null : "~/.bash_login", "~/.profile", this.getOptions().isBash() || this.getOptions().isPosix() ? null : this.getOptions().getStartupScript()}) {
                if (profileFile == null) continue;
                if (profileFile.startsWith("~/") || profileFile.startsWith("~\\")) {
                    profileFile = System.getProperty("user.home") + profileFile.substring(1);
                }
                this.executeServiceFile(this.createNewContext(this.getRootContext(), profileFile, new String[0]), true);
            }
        }
    }

    private void executeLogoutScripts() {
        if (!this.getOptions().isNoProfile()) {
            for (String profileFile : new String[]{this.getOptions().isPosix() ? null : "~/.bash_logout", this.getOptions().isBash() || this.getOptions().isPosix() ? null : this.getOptions().getStartupScript()}) {
                if (profileFile == null) continue;
                if (profileFile.startsWith("~/") || profileFile.startsWith("~\\")) {
                    profileFile = System.getProperty("user.home") + profileFile.substring(1);
                }
                this.executeServiceFile(this.createNewContext(this.getRootContext(), profileFile, new String[0]), true);
            }
        }
    }

    protected void onQuit(JShellQuitException quitException) {
        try {
            this.getHistory().save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new NutsExecutionException(this.getRootContext().getSession(), NutsMessage.cstyle((String)"%s", (Object[])new Object[]{quitException}), quitException.getExitCode());
    }

    public int executeServiceFile(JShellContext context, boolean ignoreIfNotFound) {
        NutsSession session = this.appContext.getSession();
        String file = context.getServiceName();
        if (file != null) {
            file = NutsPath.of((String)file, (NutsSession)session).toAbsolute(context.getCwd()).toString();
        }
        if (file == null || !NutsPath.of((String)file, (NutsSession)session).exists()) {
            if (ignoreIfNotFound) {
                return 0;
            }
            throw new JShellException(session, NutsMessage.cstyle((String)"shell file not found : %s", (Object[])new Object[]{file}), 1);
        }
        context.setServiceName(file);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            JShellScript ii = this.parseScript(stream);
            if (ii == null) {
                int n = 0;
                return n;
            }
            JShellContext c = context.setRootNode(ii);
            int n = context.getShell().evalNode(ii, c);
            return n;
        }
        catch (IOException ex) {
            throw new JShellException(session, ex, 1);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException ex) {
                throw new JShellException(session, ex, 1);
            }
        }
    }

    public int executeScript(String text, JShellContext context) {
        if (context == null) {
            context = this.getRootContext();
        }
        if (text == null || text.trim().isEmpty()) {
            return 0;
        }
        JShellScript ii = this.parseScript(text);
        if (ii == null) {
            return 0;
        }
        JShellContext c = context.setRootNode(ii);
        return this.evalNode(ii, c);
    }

    public int evalNode(JShellCommandNode node, JShellContext context) {
        try {
            int r = node.eval(context);
            this.onResult(r, context);
            return r;
        }
        catch (JShellUniformException th) {
            if (th.isQuit()) {
                this.onResult(null, context);
                th.throwQuit();
                return 0;
            }
            this.onResult((Throwable)((Object)th), context);
            throw th;
        }
        catch (JShellQuitException th) {
            throw th;
        }
        catch (Exception th) {
            if (this.getErrorHandler().isQuitException(th)) {
                this.onResult(null, context);
                throw new JShellUniformException(context.getSession(), this.getErrorHandler().errorToCode(th), true, th);
            }
            this.onResult(th, context);
            context.err().printf("error: %s%n", new Object[]{th});
            return this.getErrorHandler().errorToCode(th);
        }
    }

    public int safeEval(JShellCommandNode n, JShellContext context) {
        boolean success = false;
        try {
            n.eval(context);
            success = true;
        }
        catch (Exception ex2) {
            return this.onResult(ex2, context);
        }
        if (success) {
            return this.onResult(null, context);
        }
        throw new IllegalArgumentException("Unexpected behaviour");
    }

    protected String getPromptString(JShellContext context) {
        String prompt;
        NutsSession ws = context.getSession();
        String login = null;
        if (ws != null) {
            login = ws.security().getCurrentUsername();
        }
        String string = prompt = login != null && login.length() > 0 && !"anonymous".equals(login) ? login + "@" : "";
        if (!NutsBlankable.isBlank((String)this.getRootContext().getServiceName())) {
            prompt = prompt + this.getRootContext().getServiceName();
        }
        prompt = prompt + "> ";
        return prompt;
    }

    protected String getPromptString0(JShellContext context) {
        String promptValue = context.vars().getAll().getProperty("PS1");
        if (promptValue == null) {
            promptValue = "\\u> ";
        }
        char[] promptChars = promptValue.toCharArray();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < promptChars.length; ++i) {
            char c = promptChars[i];
            if (c == '\\' && i < promptChars.length - 1) {
                c = promptChars[++i];
                switch (c) {
                    case 'W': {
                        s.append(context.getCwd());
                        break;
                    }
                    case 'u': {
                        s.append(context.vars().getAll().getProperty("USER", "anonymous"));
                        break;
                    }
                    case 'h': {
                        String h = context.vars().getAll().getProperty("HOST", "nowhere");
                        if (h.contains(".")) {
                            h = h.substring(0, h.indexOf(46));
                        }
                        s.append(h);
                        break;
                    }
                    case 'H': {
                        s.append(context.vars().getAll().getProperty("HOST", "nowhere"));
                        break;
                    }
                    default: {
                        s.append('\\').append(c);
                        break;
                    }
                }
                continue;
            }
            s.append(c);
        }
        return s.toString();
    }

    public void prepareContext(JShellContext context) {
        context.vars().set(System.getenv());
        this.setUndefinedStartupEnv("USER", System.getProperty("user.name"), context);
        this.setUndefinedStartupEnv("LOGNAME", System.getProperty("user.name"), context);
        this.setUndefinedStartupEnv(ENV_PATH, ".", context);
        this.setUndefinedStartupEnv("PWD", System.getProperty("user.dir"), context);
        this.setUndefinedStartupEnv(ENV_HOME, System.getProperty("user.home"), context);
        this.setUndefinedStartupEnv("PS1", ">", context);
        this.setUndefinedStartupEnv("IFS", " \t\n", context);
    }

    private void setUndefinedStartupEnv(String name, String defaultValue, JShellContext context) {
        if (context.vars().get(name) == null) {
            context.vars().set(name, defaultValue);
        }
    }

    public JShellScript parseScript(InputStream stream) {
        JShellNode node0 = null;
        try {
            node0 = JShellParser.fromInputStream(stream).parse();
            if (node0 == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(JShell.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (node0 instanceof JShellCommandNode) {
            return new JShellScript((JShellCommandNode)node0);
        }
        throw new IllegalArgumentException("expected node " + node0);
    }

    public JShellScript parseScript(String scriptString) {
        JShellNode node0 = null;
        try {
            node0 = JShellParser.fromString(scriptString).parse();
            if (node0 == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(JShell.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (node0 instanceof JShellCommandNode) {
            return new JShellScript((JShellCommandNode)node0);
        }
        throw new IllegalArgumentException("expected node " + scriptString);
    }

    public String escapeString(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '!': 
                case '$': 
                case '&': 
                case '*': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '`': {
                    sb.append('\\');
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String escapePath(String s) {
        StringBuilder sb = new StringBuilder();
        block3: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': 
                case '?': 
                case '[': 
                case ']': {
                    sb.append('\\');
                    sb.append(c);
                    continue block3;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void traceExecution(Supplier<String> msg, JShellContext context) {
        if (this.getOptions().isXtrace()) {
            String txt = msg.get();
            context.err().println("+ " + txt);
        }
    }

    public JShellOptions getOptions() {
        return this.options;
    }

    public JShellHistory getHistory() {
        return this.history;
    }

    public String getVersion() {
        NutsId nutsId = NutsIdResolver.of((NutsSession)this.appContext.getSession()).resolveId(this.getClass());
        if (nutsId == null) {
            return "dev";
        }
        return nutsId.getVersion().getValue();
    }

    public NutsApplicationContext getAppContext() {
        return this.appContext;
    }

    public MemResult executeCommand(String[] command) {
        return this.executeCommand(command, (String)null);
    }

    public MemResult executeCommand(String[] command, String in) {
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        ByteArrayPrintStream oout = new ByteArrayPrintStream();
        ByteArrayPrintStream oerr = new ByteArrayPrintStream();
        JShellContext newContext = this.createNewContext(this.getRootContext(), command[0], Arrays.copyOfRange(command, 1, command.length));
        newContext.setIn(new ByteArrayInputStream(in == null ? new byte[]{} : in.getBytes()));
        newContext.setOut(oout);
        newContext.setErr(oerr);
        int r = this.executeCommand(command, newContext);
        out.append(oout);
        err.append(oerr);
        return new MemResult(out.toString(), err.toString(), r);
    }

    public JShellContext createContext(JShellContext ctx, JShellNode root, JShellNode parent, JShellVariables env, String serviceName, String[] args) {
        return new DefaultJShellContext(this, root, parent, ctx, this.appContext.getSession().getWorkspace(), this.appContext.getSession(), env, serviceName, args);
    }
}

