/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.toolbox.nsh.jshell.AbstractJShellHistory;

public class DefaultJShellHistory
extends AbstractJShellHistory {
    private List<String> history = new ArrayList<String>();
    private NutsPath historyFile;

    @Override
    public NutsPath getHistoryFile() {
        return this.historyFile;
    }

    @Override
    public DefaultJShellHistory setHistoryFile(NutsPath historyFile) {
        this.historyFile = historyFile;
        return this;
    }

    @Override
    public void add(String e) {
        String l;
        if (e != null && e.trim().length() > 0 && !e.equals(l = this.getLast())) {
            this.history.add(e);
        }
    }

    @Override
    public void removeDuplicates() {
        LinkedHashSet<String> vals = new LinkedHashSet<String>();
        for (String s : this.history) {
            vals.add(s);
        }
        this.history.clear();
        this.history.addAll(vals);
    }

    @Override
    public List<String> getElements() {
        return new ArrayList<String>(this.history);
    }

    @Override
    public List<String> getElements(int maxElements) {
        if (maxElements < 0) {
            return new ArrayList<String>(this.history);
        }
        ArrayList<String> all = new ArrayList<String>();
        if (maxElements <= 0 || maxElements > this.history.size()) {
            maxElements = this.history.size();
        }
        for (int i = 0; i < maxElements; ++i) {
            all.add(this.history.get(this.history.size() - maxElements + i));
        }
        return all;
    }

    @Override
    public int size() {
        return this.history.size();
    }

    @Override
    public void clear() {
        this.history.clear();
    }

    @Override
    public void remove(int index) {
        if (index >= 0 && index < this.history.size()) {
            this.history.remove(index);
        }
    }

    @Override
    public void load() throws IOException {
        this.load(this.getHistoryFile());
    }

    @Override
    public void save() throws IOException {
        this.save(this.getHistoryFile());
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public String get(int index) {
        if (index < 0 || index >= this.history.size()) {
            return null;
        }
        return this.history.get(index);
    }

    @Override
    public String getLast() {
        return this.get(this.size() - 1);
    }
}

