/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.InputStream;
import net.thevpc.nuts.NutsApplicationContext;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsTerminalMode;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nsh.jshell.JShell;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

public class DefaultJShellExecutionContext
implements JShellExecutionContext {
    private JShellContext shellContext;
    private NutsSession session;
    private JShellBuiltin builtin;
    private NutsTerminalMode terminalMode = null;
    private boolean askHelp;
    private boolean askVersion;
    private Object options;

    public DefaultJShellExecutionContext(JShellContext shellContext, JShellBuiltin command) {
        this.shellContext = shellContext;
        this.session = shellContext.getSession().copy();
        this.builtin = command;
    }

    @Override
    public NutsWorkspace getWorkspace() {
        return this.shellContext.getWorkspace();
    }

    @Override
    public NutsSession getSession() {
        return this.session;
    }

    @Override
    public JShell getShell() {
        return this.shellContext.getShell();
    }

    @Override
    public NutsPrintStream out() {
        return this.getSession().out();
    }

    @Override
    public NutsPrintStream err() {
        return this.getSession().err();
    }

    @Override
    public InputStream in() {
        return this.getSession().in();
    }

    @Override
    public JShellContext getShellContext() {
        return this.shellContext;
    }

    @Override
    public boolean configureFirst(NutsCommandLine cmd) {
        NutsArgument a = cmd.peek();
        if (a == null) {
            return false;
        }
        switch (a.getKey().getString()) {
            case "--help": {
                cmd.skip();
                this.setAskHelp(true);
                while (cmd.hasNext()) {
                    this.getSession().configureLast(cmd);
                }
                break;
            }
            case "--version": {
                cmd.skip();
                this.setAskVersion(true);
                while (cmd.hasNext()) {
                    this.getSession().configureLast(cmd);
                }
                break;
            }
            default: {
                if (this.getSession() == null || !this.getSession().configureFirst(cmd)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAskVersion() {
        return this.askVersion;
    }

    public DefaultJShellExecutionContext setAskVersion(boolean askVersion) {
        this.askVersion = askVersion;
        return this;
    }

    @Override
    public void configureLast(NutsCommandLine cmd) {
        if (!this.configureFirst(cmd)) {
            cmd.unexpectedArgument();
        }
    }

    @Override
    public NutsApplicationContext getAppContext() {
        return this.getShell().getAppContext();
    }

    public NutsTerminalMode geTerminalMode() {
        return this.terminalMode;
    }

    @Override
    public boolean isAskHelp() {
        return this.askHelp;
    }

    public DefaultJShellExecutionContext setAskHelp(boolean askHelp) {
        this.askHelp = askHelp;
        return this;
    }

    @Override
    public <T> T getOptions() {
        return (T)this.options;
    }

    @Override
    public DefaultJShellExecutionContext setOptions(Object options) {
        this.options = options;
        return this;
    }
}

