/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.StringTokenizer;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellCommandNode;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellEvaluator;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellException;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellScript;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellUniformException;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStream;
import net.thevpc.nuts.toolbox.nsh.jshell.util.JavaShellNonBlockingInputStreamAdapter;
import net.thevpc.nuts.toolbox.nsh.jshell.util.ShellUtils;

public class DefaultJShellEvaluator
implements JShellEvaluator {
    public static int readQuotes(char[] chars, int i, StringBuilder v) {
        return ShellUtils.readQuotes(chars, i, v);
    }

    protected int readAndEvalSimpleQuotesExpression(char[] chars, int i, StringBuilder out, JShellContext context) {
        StringBuilder v = new StringBuilder();
        int count = DefaultJShellEvaluator.readQuotes(chars, i, v);
        out.append(this.evalSimpleQuotesExpression(v.toString(), context));
        return i + count;
    }

    protected int readAndEvalAntiQuotesString(char[] chars, int i, StringBuilder out, JShellContext context) {
        StringBuilder v = new StringBuilder();
        int count = DefaultJShellEvaluator.readQuotes(chars, i, v);
        out.append(this.evalAntiQuotesExpression(v.toString(), context));
        return i + count;
    }

    protected int readAndEvalDblQuotesExpression(char[] chars, int i, StringBuilder out, JShellContext context) {
        StringBuilder v = new StringBuilder();
        int count = DefaultJShellEvaluator.readQuotes(chars, i, v);
        out.append(this.evalDoubleQuotesExpression(v.toString(), context));
        return i + count;
    }

    protected int readAndEvalDollarExpression(char[] chars, int i, StringBuilder out, boolean escapeResultPath, JShellContext context) {
        if (i + 1 < chars.length) {
            if (chars[++i] == '{') {
                StringBuilder v = new StringBuilder();
                while (i < chars.length && chars[i] != '}') {
                    v.append(chars[i]);
                    ++i;
                }
                String r = this.evalDollarExpression(v.toString(), context);
                if (escapeResultPath) {
                    r = context.getShell().escapePath(r);
                }
                out.append(r);
            } else {
                StringBuilder v = new StringBuilder();
                while (i < chars.length && chars[i] != ' ' && chars[i] != '\t') {
                    v.append(chars[i]);
                    ++i;
                }
                String r = this.evalDollarExpression(String.valueOf(v.toString()), context);
                if (escapeResultPath) {
                    r = context.getShell().escapePath(r);
                }
                out.append(r);
            }
        }
        return i;
    }

    @Override
    public int evalSuffixOperation(String opString, JShellCommandNode node, JShellContext context) {
        switch (opString) {
            case "&": {
                return this.evalSuffixAndOperation(node, context);
            }
        }
        throw new JShellException(context.getSession(), NutsMessage.cstyle((String)"unsupported suffix operator %s", (Object[])new Object[]{opString}), 1);
    }

    @Override
    public int evalSuffixAndOperation(JShellCommandNode node, JShellContext context) {
        return context.getShell().evalNode(node, context);
    }

    @Override
    public int evalBinaryAndOperation(JShellCommandNode left, JShellCommandNode right, JShellContext context) {
        int r = context.getShell().evalNode(left, context);
        if (r != 0) {
            return r;
        }
        return context.getShell().evalNode(right, context);
    }

    @Override
    public int evalBinaryOperation(String opString, JShellCommandNode left, JShellCommandNode right, JShellContext context) {
        if (!";".equals(opString)) {
            context.getShell().traceExecution(() -> "(" + left + ") " + opString + "(" + right + ")", context);
        }
        if (";".equals(opString)) {
            return this.evalBinarySuiteOperation(left, right, context);
        }
        if ("&&".equals(opString)) {
            return this.evalBinaryAndOperation(left, right, context);
        }
        if ("||".equals(opString)) {
            return this.evalBinaryOrOperation(left, right, context);
        }
        if ("|".equals(opString)) {
            return this.evalBinaryPipeOperation(left, right, context);
        }
        throw new JShellException(context.getSession(), NutsMessage.cstyle((String)"unsupported operator %s", (Object[])new Object[]{opString}), 1);
    }

    @Override
    public int evalBinaryOrOperation(JShellCommandNode left, JShellCommandNode right, JShellContext context) {
        block3: {
            try {
                if (context.getShell().evalNode(left, context) == 0) {
                    return 0;
                }
            }
            catch (JShellUniformException e) {
                if (!e.isQuit()) break block3;
                e.throwQuit();
                return 0;
            }
        }
        return context.getShell().evalNode(right, context);
    }

    @Override
    public int evalBinaryPipeOperation(final JShellCommandNode left, JShellCommandNode right, final JShellContext context) {
        JavaShellNonBlockingInputStream in2;
        PipedOutputStream out;
        try {
            out = new PipedOutputStream();
            PipedInputStream in = new PipedInputStream(out, 1024);
            in2 = in instanceof JavaShellNonBlockingInputStream ? (JavaShellNonBlockingInputStream)((Object)in) : new JavaShellNonBlockingInputStreamAdapter("jpipe-" + right.toString(), in);
        }
        catch (IOException ex) {
            throw new JShellException(context.getSession(), ex, 1);
        }
        final JShellUniformException[] a = new JShellUniformException[2];
        PrintStream out1 = new PrintStream(out);
        final JShellContext leftContext = context.getShell().createNewContext(context).setOut(out1);
        Thread j1 = new Thread(){

            @Override
            public void run() {
                try {
                    context.getShell().evalNode(left, leftContext);
                }
                catch (JShellUniformException e) {
                    if (e.isQuit()) {
                        e.throwQuit();
                        return;
                    }
                    a[0] = e;
                }
                in2.noMoreBytes();
            }
        };
        j1.start();
        JShellContext rightContext = context.getShell().createNewContext(context).setIn((InputStream)((Object)in2));
        try {
            context.getShell().evalNode(right, rightContext);
        }
        catch (JShellUniformException e) {
            if (e.isQuit()) {
                e.throwQuit();
                return 0;
            }
            a[1] = e;
        }
        out1.flush();
        try {
            j1.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (a[1] != null) {
            a[1].throwAny();
        }
        return 0;
    }

    @Override
    public int evalBinarySuiteOperation(JShellCommandNode left, JShellCommandNode right, JShellContext context) {
        int r;
        block3: {
            r = 0;
            try {
                r = context.getShell().evalNode(left, context);
            }
            catch (JShellUniformException e) {
                if (!e.isQuit()) break block3;
                e.throwQuit();
                return 0;
            }
        }
        if (r != 0 && context.getShell().getOptions().isErrExit()) {
            return r;
        }
        return context.getShell().evalNode(right, context);
    }

    @Override
    public String evalCommandAndReturnString(JShellCommandNode command, JShellContext context) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JShellContext c2 = context.getShell().createNewContext(context, context.getServiceName(), context.getArgsArray());
        PrintStream p = new PrintStream(out);
        c2.setOut(p);
        context.getShell().evalNode(command, c2);
        p.flush();
        String cc = this.evalFieldSubstitutionAfterCommandSubstitution(out.toString(), context);
        return context.getShell().escapeString(cc);
    }

    @Override
    public String evalDollarSharp(JShellContext context) {
        return String.valueOf(context.getArgsList().size());
    }

    @Override
    public String evalDollarName(String name, JShellContext context) {
        return String.valueOf(context.vars().get(name, ""));
    }

    @Override
    public String evalDollarInterrogation(JShellContext context) {
        return String.valueOf(context.getLastResult().getCode());
    }

    @Override
    public String evalDollarInteger(int index, JShellContext context) {
        if (index < context.getArgsList().size()) {
            return String.valueOf(context.getArg(index));
        }
        return "";
    }

    @Override
    public String evalDollarExpression(String stringExpression, JShellContext context) {
        String str = this.evalSimpleQuotesExpression(stringExpression, context);
        if (str.equals("#")) {
            return this.evalDollarSharp(context);
        }
        if (str.equals("?")) {
            return this.evalDollarInterrogation(context);
        }
        if (str.isEmpty()) {
            return "";
        }
        if (str.charAt(0) >= '0' && str.charAt(0) <= '9') {
            int index = Integer.parseInt(str, 10);
            return this.evalDollarInteger(index, context);
        }
        return this.evalDollarName(str, context);
    }

    @Override
    public String evalSimpleQuotesExpression(String expressionString, JShellContext context) {
        StringBuilder sb = new StringBuilder();
        char[] chars = expressionString.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '$': {
                    sb.append(chars[i]);
                    continue block5;
                }
                case '\"': {
                    i = this.readAndEvalDblQuotesExpression(chars, i, sb, context);
                    continue block5;
                }
                case '`': {
                    i = this.readAndEvalAntiQuotesString(chars, i, sb, context);
                    continue block5;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String evalDoubleQuotesExpression(String stringExpression, JShellContext context) {
        StringBuilder sb = new StringBuilder();
        char[] chars = stringExpression.toCharArray();
        block5: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '$': {
                    i = this.readAndEvalDollarExpression(chars, i, sb, false, context);
                    continue block5;
                }
                case '\'': {
                    i = this.readAndEvalSimpleQuotesExpression(chars, i, sb, context);
                    continue block5;
                }
                case '`': {
                    i = this.readAndEvalAntiQuotesString(chars, i, sb, context);
                    continue block5;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String evalAntiQuotesExpression(String stringExpression, JShellContext context) {
        context.getShell().traceExecution(() -> "`" + stringExpression + "`", context);
        JShellScript t = context.getShell().parseScript(stringExpression);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JShellContext c2 = context.getShell().createNewContext(context);
        c2.setOut(new PrintStream(out));
        context.getShell().evalNode(t, c2);
        c2.out().flush();
        return out.toString();
    }

    @Override
    public String evalNoQuotesExpression(String stringExpression, JShellContext context) {
        StringBuilder sb = new StringBuilder();
        char[] chars = stringExpression.toCharArray();
        block4: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '$': {
                    i = this.readAndEvalDollarExpression(chars, i, sb, true, context);
                    continue block4;
                }
                case '\\': {
                    sb.append(chars[++i]);
                    continue block4;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public String expandEnvVars(String stringExpression, boolean escapeResultPath, JShellContext context) {
        StringBuilder sb = new StringBuilder();
        char[] chars = stringExpression.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            switch (c) {
                case '$': {
                    i = this.readAndEvalDollarExpression(chars, i, sb, true, context);
                    continue block3;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public String evalFieldSubstitutionAfterCommandSubstitution(String commandResult, JShellContext context) {
        String IFS = context.vars().get("IFS", " \t\n");
        if (!IFS.isEmpty()) {
            StringTokenizer st = new StringTokenizer(commandResult, IFS);
            StringBuilder sb = new StringBuilder();
            while (st.hasMoreTokens()) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(st.nextToken());
            }
            return sb.toString();
        }
        return commandResult;
    }
}

