/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.jshell;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thevpc.nuts.NutsArgumentCandidate;
import net.thevpc.nuts.NutsCommandAutoComplete;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsDefaultCommandAutoComplete;
import net.thevpc.nuts.NutsDefinition;
import net.thevpc.nuts.NutsDependencyScopePattern;
import net.thevpc.nuts.NutsDescriptor;
import net.thevpc.nuts.NutsExecCommand;
import net.thevpc.nuts.NutsFetchStrategy;
import net.thevpc.nuts.NutsFunction;
import net.thevpc.nuts.NutsId;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsPathOption;
import net.thevpc.nuts.NutsPrintStream;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUtilStrings;
import net.thevpc.nuts.NutsWorkspace;
import net.thevpc.nuts.toolbox.nsh.jshell.DefaultJShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellAutoCompleteCandidate;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellContext;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import net.thevpc.nuts.toolbox.nsh.jshell.WatcherImpl;

public abstract class AbstractJShellContext
implements JShellContext {
    private final List<String> args = new ArrayList<String>();
    private NutsSession session;
    private String serviceName;

    @Override
    public InputStream in() {
        return this.getSession().getTerminal().in();
    }

    @Override
    public NutsPrintStream out() {
        return this.getSession().getTerminal().getOut();
    }

    @Override
    public NutsPrintStream err() {
        return this.getSession().getTerminal().getErr();
    }

    @Override
    public JShellContext.Watcher bindStreams(InputStream out, InputStream err, OutputStream in) {
        WatcherImpl w = new WatcherImpl();
        new Thread(() -> {
            byte[] buffer = new byte[4024];
            boolean some = false;
            do {
                int x;
                if (out != null) {
                    try {
                        if (out.available() > 0 && (x = out.read(buffer)) > 0) {
                            this.out().write(buffer, 0, x);
                            some = true;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (err != null) {
                    try {
                        if (err.available() > 0 && (x = err.read(buffer)) > 0) {
                            this.err().write(buffer, 0, x);
                            some = true;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in == null) continue;
                try {
                    if (this.in().available() <= 0 || (x = this.in().read(buffer)) <= 0) continue;
                    in.write(buffer, 0, x);
                    some = true;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } while (some || !w.askStopped);
        }).start();
        return w;
    }

    @Override
    public JShellContext setOut(PrintStream out) {
        this.getSession().getTerminal().setOut(NutsPrintStream.of((OutputStream)out, (NutsSession)this.getSession()));
        return this;
    }

    @Override
    public JShellContext setErr(PrintStream err) {
        this.getSession().getTerminal().setErr(NutsPrintStream.of((OutputStream)err, (NutsSession)this.getSession()));
        return this;
    }

    @Override
    public JShellContext setIn(InputStream in) {
        this.getSession().getTerminal().setIn(in);
        return this;
    }

    @Override
    public JShellExecutionContext createCommandContext(JShellBuiltin command) {
        DefaultJShellExecutionContext c = new DefaultJShellExecutionContext(this, command);
        return c;
    }

    @Override
    public List<JShellAutoCompleteCandidate> resolveAutoCompleteCandidates(String commandName, List<String> autoCompleteWords, int wordIndex, String autoCompleteLine) {
        JShellBuiltin command = this.builtins().find(commandName);
        NutsDefaultCommandAutoComplete autoComplete = new NutsDefaultCommandAutoComplete().setSession(this.getSession()).setLine(autoCompleteLine).setWords(autoCompleteWords).setCurrentWordIndex(wordIndex);
        if (command != null) {
            command.autoComplete(new DefaultJShellExecutionContext(this, command), (NutsCommandAutoComplete)autoComplete);
        } else {
            NutsSession session = this.getSession();
            List nutsIds = session.search().addId(commandName).setLatest(true).addScope(NutsDependencyScopePattern.RUN).setOptional(Boolean.valueOf(false)).setSession(this.getSession().copy().setFetchStrategy(NutsFetchStrategy.OFFLINE)).getResultIds().toList();
            if (nutsIds.size() == 1) {
                NutsExecCommand t;
                NutsId selectedId = (NutsId)nutsIds.get(0);
                NutsDefinition def = (NutsDefinition)session.search().addId(selectedId).setEffective(true).setSession(this.getSession().copy().setFetchStrategy(NutsFetchStrategy.OFFLINE)).getResultDefinitions().required();
                NutsDescriptor d = def.getDescriptor();
                String nuts_autocomplete_support = NutsUtilStrings.trim((String)d.getPropertyValue("nuts.autocomplete"));
                if ((d.isApplication() || "true".equalsIgnoreCase(nuts_autocomplete_support) || "supported".equalsIgnoreCase(nuts_autocomplete_support)) && (t = session.exec().grabOutputString().grabErrorString().addCommand(new String[]{selectedId.getLongName(), "--nuts-exec-mode=auto-complete " + wordIndex}).addCommand(autoCompleteWords).run()).getResult() == 0) {
                    String rr = t.getOutputString();
                    for (String s : rr.split("\n")) {
                        if ((s = s.trim()).length() <= 0) continue;
                        if (!s.startsWith("```error Candidate```: ")) break;
                        s = s.substring("```error Candidate```: ".length()).trim();
                        NutsCommandLine args = NutsCommandLine.of((String)s, (NutsSession)session);
                        String value = null;
                        String display = null;
                        if (args.hasNext()) {
                            value = args.next().getString();
                            if (args.hasNext()) {
                                display = args.next().getString();
                            }
                        }
                        if (value == null) continue;
                        if (display == null) {
                            display = value;
                        }
                        autoComplete.addCandidate(new NutsArgumentCandidate(value));
                    }
                }
            }
        }
        ArrayList<JShellAutoCompleteCandidate> all = new ArrayList<JShellAutoCompleteCandidate>();
        for (NutsArgumentCandidate a : autoComplete.getCandidates()) {
            all.add(new JShellAutoCompleteCandidate(a.getValue(), a.getDisplay()));
        }
        return all;
    }

    @Override
    public String getAbsolutePath(String path) {
        if (NutsPath.of((String)path, (NutsSession)this.getSession()).isAbsolute()) {
            return this.getFileSystem().getAbsolutePath(path, this.getSession());
        }
        return this.getFileSystem().getAbsolutePath(this.getCwd() + "/" + path, this.getSession());
    }

    @Override
    public String[] expandPaths(String path) {
        return (String[])NutsPath.of((String)path, (NutsSession)this.getSession()).walkGlob(new NutsPathOption[0]).map(NutsFunction.of(NutsPath::toString, (String)"toString")).toArray(String[]::new);
    }

    @Override
    public void copyFrom(JShellContext other) {
        if (other != null) {
            this.setSession(other.getSession() == null ? null : other.getSession().copy());
            this.setAliases(other.aliases());
            this.setBuiltins(other.builtins());
            this.setRootNode(other.getRootNode());
            this.setParentNode(other.getParentNode());
            this.setFileSystem(other.getFileSystem());
            this.setCwd(other.getCwd());
            this.setFunctionManager(other.functions());
        }
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public void setArgs(String[] args) {
        this.args.clear();
        this.args.addAll(Arrays.asList(args));
    }

    @Override
    public String getArg(int index) {
        List<String> argsList = this.getArgsList();
        if (index >= 0 && index < argsList.size()) {
            String r = argsList.get(index);
            return r == null ? "" : r;
        }
        return "";
    }

    @Override
    public int getArgsCount() {
        return this.args.size();
    }

    @Override
    public String[] getArgsArray() {
        return this.args.toArray(new String[0]);
    }

    @Override
    public List<String> getArgsList() {
        return this.args;
    }

    @Override
    public NutsSession getSession() {
        return this.session;
    }

    @Override
    public JShellContext setSession(NutsSession session) {
        this.session = session;
        return this;
    }

    @Override
    public NutsWorkspace getWorkspace() {
        return this.getSession().getWorkspace();
    }
}

