/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class XmlCommand
extends SimpleJShellBuiltin {
    public XmlCommand() {
        super("xml", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextString(new String[]{"-f", "--file"});
        if (a != null) {
            options.input = a.getValue().getString();
            return true;
        }
        a = commandLine.nextString(new String[]{"-q", "--xpath"});
        if (a != null) {
            options.xpaths.add(a.getValue().getString());
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Document doc;
        NutsSession session;
        Options options;
        block32: {
            DocumentBuilder dBuilder;
            options = (Options)context.getOptions();
            if (options.xpaths.isEmpty()) {
                commandLine.required();
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            session = context.getSession();
            try {
                dBuilder = dbFactory.newDocumentBuilder();
            }
            catch (Exception ex) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"updable to initialize xml system", (Object[])new Object[0]), (Throwable)ex, 3);
            }
            doc = null;
            if (options.input != null) {
                NutsPath file = NutsPath.of((String)options.input, (NutsSession)session).toAbsolute(context.getShellContext().getCwd());
                if (file.isFile()) {
                    try (InputStream is = file.getInputStream();){
                        doc = dBuilder.parse(is);
                        break block32;
                    }
                    catch (Exception ex) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid xml %s", (Object[])new Object[]{options.input}), (Throwable)ex, 2);
                    }
                }
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid path %s", (Object[])new Object[]{options.input}), 1);
            }
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String line = null;
                try {
                    line = reader.readLine();
                }
                catch (IOException ex) {
                    throw new NutsExecutionException(session, NutsMessage.cstyle((String)"broken Input", (Object[])new Object[0]), 2);
                }
                if (line == null) {
                    try {
                        doc = dBuilder.parse(new InputSource(new StringReader(sb.toString())));
                        break;
                    }
                    catch (Exception ex) {
                        throw new NutsExecutionException(session, NutsMessage.cstyle((String)"invalid xml : %s", (Object[])new Object[]{sb}), (Throwable)ex, 2);
                    }
                }
                sb.append(line);
                try {
                    doc = dBuilder.parse(new InputSource(new StringReader(sb.toString())));
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
        doc.getDocumentElement().normalize();
        ArrayList<Document> all = new ArrayList<Document>();
        all.add(doc);
        XPath xPath = XPathFactory.newInstance().newXPath();
        ArrayList<NodeList> result = new ArrayList<NodeList>();
        for (String query : options.xpaths) {
            try {
                result.add((NodeList)xPath.compile(query).evaluate(doc, XPathConstants.NODESET));
            }
            catch (XPathExpressionException ex) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), (Throwable)ex, 103);
            }
        }
        if (all.size() == 1) {
            session.out().printlnf(all.get(0));
        } else {
            session.out().printlnf(all);
        }
    }

    private static class Options {
        String input;
        List<String> xpaths = new ArrayList<String>();

        private Options() {
        }
    }
}

