/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsBlankable;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.NutsExecutionException;
import net.thevpc.nuts.NutsIOException;
import net.thevpc.nuts.NutsIOUncompressVisitor;
import net.thevpc.nuts.NutsMessage;
import net.thevpc.nuts.NutsPath;
import net.thevpc.nuts.NutsSession;
import net.thevpc.nuts.NutsUncompress;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class UnzipCommand
extends SimpleJShellBuiltin {
    public UnzipCommand() {
        super("unzip", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.nextBoolean(new String[]{"-l"});
        if (a != null) {
            options.l = a.getBooleanValue();
            return true;
        }
        a = commandLine.nextString(new String[]{"-d"});
        if (a != null) {
            options.dir = a.getValue().getString();
            return true;
        }
        if (!commandLine.peek().isOption()) {
            while (commandLine.hasNext()) {
                options.files.add(commandLine.next().getString());
            }
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.files.isEmpty()) {
            commandLine.required();
        }
        final NutsSession session = context.getSession();
        for (String path : options.files) {
            NutsPath file = NutsPath.of((String)path, (NutsSession)session).toAbsolute(context.getShellContext().getCwd());
            try {
                if (options.l) {
                    NutsUncompress.of((NutsSession)session).from(file).visit(new NutsIOUncompressVisitor(){

                        public boolean visitFolder(String path) {
                            return true;
                        }

                        public boolean visitFile(String path, InputStream inputStream) {
                            session.out().printf("%s\n", new Object[]{path});
                            return true;
                        }
                    });
                    continue;
                }
                String dir = options.dir;
                if (NutsBlankable.isBlank((String)dir)) {
                    dir = context.getShellContext().getCwd();
                }
                dir = context.getShellContext().getAbsolutePath(dir);
                NutsUncompress.of((NutsSession)session).from(file).to(dir).setSkipRoot(options.skipRoot).run();
            }
            catch (UncheckedIOException | NutsIOException ex) {
                throw new NutsExecutionException(session, NutsMessage.cstyle((String)"%s", (Object[])new Object[]{ex}), ex, 1);
            }
        }
    }

    private static class Options {
        boolean l = false;
        boolean skipRoot = false;
        String dir = null;
        List<String> files = new ArrayList<String>();

        private Options() {
        }
    }
}

