/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class UnsetCommand
extends SimpleJShellBuiltin {
    public UnsetCommand() {
        super("unset", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isOption()) {
            if (a.getKey().getString().equals("-v")) {
                options.fct = !commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
            if (a.getKey().getString().equals("-f")) {
                options.fct = commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
        } else {
            options.list.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.fct) {
            for (String k : options.list) {
                context.getShellContext().functions().unset(k);
            }
        } else {
            for (String k : options.list) {
                context.getShellContext().aliases().set(k, null);
            }
        }
    }

    private static class Options {
        boolean fct;
        Set<String> list = new HashSet<String>();

        private Options() {
        }
    }
}

