/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.toolbox.nsh.cmds;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.thevpc.nuts.NutsArgument;
import net.thevpc.nuts.NutsCommandLine;
import net.thevpc.nuts.spi.NutsComponentScope;
import net.thevpc.nuts.spi.NutsComponentScopeType;
import net.thevpc.nuts.toolbox.nsh.SimpleJShellBuiltin;
import net.thevpc.nuts.toolbox.nsh.jshell.JShellExecutionContext;

@NutsComponentScope(value=NutsComponentScopeType.WORKSPACE)
public class UnaliasCommand
extends SimpleJShellBuiltin {
    public UnaliasCommand() {
        super("unalias", 10, Options.class);
    }

    @Override
    protected boolean configureFirst(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        NutsArgument a = commandLine.peek();
        if (a.isOption()) {
            if (a.getKey().getString().equals("-a")) {
                options.all = commandLine.nextBoolean(new String[0]).getBooleanValue();
                return true;
            }
        } else {
            options.list.addAll(Arrays.asList(commandLine.toStringArray()));
            commandLine.skipAll();
            return true;
        }
        return false;
    }

    @Override
    protected void execBuiltin(NutsCommandLine commandLine, JShellExecutionContext context) {
        Options options = (Options)context.getOptions();
        if (options.all) {
            for (String k : context.getShellContext().aliases().getAll()) {
                context.getShellContext().aliases().set(k, null);
            }
        } else {
            for (String k : options.list) {
                context.getShellContext().aliases().set(k, null);
            }
        }
    }

    private static class Options {
        boolean all;
        Set<String> list = new HashSet<String>();

        private Options() {
        }
    }
}

